<!DOCTYPE html>
<html>
  <head>
    <title>Crea una cuenta en GuateHoteles</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" type="text/css" href="{{asset('css/theme.css')}}">
    {!! NoCaptcha::renderJs() !!}
  </head>
  <body>
    <section class="height-100" style="background: linear-gradient(90deg, #0099FF 0%, #6610f2 100%);">
      <img src="{{asset('img/bg.png')}}" alt="Image" class="bg-image opacity-10">
      <div class="container">
        <div class="row justify-content-center">
          <div class="col-lg-5 col-md-7">
            <div class="card py-3 shadow-lg">
              <div class="card-body">
                <h1 class="h2 text-center">
                  <a href="{{route('inicio')}}">
                    <img src="{{asset('img/logo.png')}}" style="height: 70px;">
                  </a>
                </h1>
                    <form method="POST" action="{{ route('register') }}">
                        @csrf
                        <!--<a class="btn btn-primary" href="{{ route('social.auth', 'facebook') }}">
                            Facebook
                        </a>-->
                        
                        <div class="form-group row">
                            <label for="name" class="col-md-12 col-form-label ">{{ __('Name') }}</label>

                            <div class="col-md-12">
                                <input id="name" type="text" class="form-control @error('name') is-invalid @enderror" name="name" value="{{ old('name') }}" required autocomplete="name" autofocus placeholder="introduzca su nombre">

                                @error('name')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="email" class="col-md-12 col-form-label ">{{ __('E-Mail Address') }}</label>

                            <div class="col-md-12">
                                <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required autocomplete="email" placeholder="Ej. ejemplo@ejemplo.com">

                                @error('email')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="cuenta" class="col-md-12 col-form-label ">Tipo de cuenta</label>

                            <div class="col-md-12">
                                <select class="form-control" required="required" name="rol">
                                    <option value="">Seleccione una opción</option>
                                    <option value="3">Normal</option>
                                    <option value="2">Hotelera</option>
                                </select>

                                @error('email')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="password" class="col-md-12 col-form-label ">{{ __('Password') }}</label>

                            <div class="col-md-12">
                                <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" required autocomplete="new-password" 
                                placeholder="Escriba su contraseña">

                                @error('password')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="password-confirm" class="col-md-12 col-form-label ">{{ __('Confirm Password') }}</label>

                            <div class="col-md-12">
                                <input id="password-confirm" type="password" class="form-control" name="password_confirmation" required autocomplete="new-password" placeholder="Repita su contraseña">
                            </div>
                        </div>

                        <div class="form-group row">
                            <div class="col-md-12">
                                 <div class="m-1">
                                  <center>
                                    {!! NoCaptcha::display() !!}
                                    @if ($errors->has('g-recaptcha-response'))
                                        <span class="help-block text-danger" role="alert">
                                            <strong>{{ $errors->first('g-recaptcha-response') }}</strong>
                                        </span>
                                    @endif
                                  </center>
                                </div>
                                <button type="submit" class="btn btn-block btn-lg btn-primary">
                                    Registrarme ahora
                                </button>
                            </div>
                        </div>
                    </form>
                <div class="text-center text-small mt-3">
                  <span>¿Ya tienes una cuenta ? <a href="{{route('login')}}">Iniciar Sesión</a></span>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  </body>
</html>
