@extends('admin.layouts.app')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="javascript:void(0);">Inicio</a></li>
    <li class="breadcrumb-item" aria-current="page"><a href="{{route('hoteles.index')}}">Hoteles</a></li>
    <li class="breadcrumb-item" aria-current="page"><a href="{{route('habitaciones.index',$id)}}">Habitaciones</a></li>
    <li class="breadcrumb-item active" aria-current="page"><span>Editar</span></li>
@endsection

@section('css')
<link rel="stylesheet" type="text/css" href="{{asset('css/forms/switches.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('css/forms/theme-checkbox-radio.css')}}">
<style type="text/css">
    #imgPreview{
        width: 100%;
        text-align: center;
    }
    #map{
            height: 500px;
        }

    .img-vista img{
        min-width: 100%;
        max-width: 100%;
    }
</style>
@endsection

@section('content')
<div class="row layout-spacing layout-top-spacing feather-icon">
    <div id="font-icon_feather" class="col-lg-12">
        <div class="statbox widget box box-shadow">
            <div class="widget-content widget-content-area bx-top-6">
                <div class="icon-section">
                    <div class="row">
                        <div class="col-xl-12">
                            
                            <center><h4>Editar Habitación</h4></center>
                            <hr>

                            <form action="{{route('habitaciones.update',$id)}}" method="post">
                                @csrf
                                <br>
                                <div class="row">
                                    <div class="col-md-12">
                                        <h6>Nombre <strong class="text-danger">*</strong></h6>
                                        <input type="text" name="nombre" class="form-control" placeholder="Escriba el nombre del hotel" required="required" value="{{$habitacion->nombre}}"><br>
                                    </div><br>
                                </div>      
                                <?php $nro_fotos=0; ?>
          
                                <div class="row img-color-div" id="img-color-null">
                                            <div class="col-md-12">
                                                <p class="mt-2 ml-1" style="display: inline-block;"><strong>Fotos</strong></p>
                                            </div>
                                            <div class="row m-3">
                                                @foreach($habitacion->imagenes as $key2)
                                                    <div class="col-md-3" id="div-foto-db-{{$key2->id}}">
                                                        <div class='imgPreview'>
                                                            <img src="{{asset($key2->img)}}">
                                                        </div>
                                                        <div> 
                                                            <center> 
                                                                <br>
                                                                <button type="button" class="btn btn-outline-danger" onclick="delete_db_foto('{{$key2->id}}');">Eliminar</button>  
                                                            </center>
                                                         </div>
                                                    </div>

                                                @endforeach
                                                <div id="imgPreview-" class="col-12"></div>
                                            </div>
                                            <div class="col-md-12">
                                                <br>
                                                <div class="cz-file-drop-area">
                                                  <div class="cz-file-drop-icon czi-cloud-upload"></div>
                                                  <span class="cz-file-drop-message">
                                                   Arrastra y suelta aquí para subir una foto</span>
                                                  <input type="file" 
                                                      accept="image/x-png,image/jpeg" 
                                                      class="cz-file-drop-input input-foto"
                                                      color="" 
                                                      multiple="multiple">
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <div id="img-db"></div>
                                                <div id="img_db_delete"></div>
                                                <hr>
                                            </div>
                                </div>
                                
                                <br>

                                <div class="row">
                                    <div class="col-12">
                                        <center><h4><strong>Equipamiento del Baño</strong></h4></center>
                                    </div>
                                    <div class="col-md-6">
                                        <div>
                                            @foreach($ser_tocador as $key)

                                                <label class="switch s-outline s-primary mr-2" style="display: inline-block; margin-bottom: 0px">
                                                    <input type="checkbox" name="servicios[]" value="{{$key->id}}"
                                                    <?php 
                                                        if (in_array($key->id, $equipos)) {
                                                            echo "checked='checked'";
                                                        }
                                                    ?>
                                                    >
                                                    <span class="slider round"></span>
                                                </label>

                                                <h5 style="display: inline-block; padding: 0px;">{{$key->equipo}}</h5><br>

                                            @endforeach
                                        </div>                                        
                                    </div>
                                    <div class="col-md-6 d-none d-md-block">
                                        <br><br>
                                        <center>
                                            <svg xmlns="http://www.w3.org/2000/svg" enable-background="new 0 0 24 24" viewBox="0 0 24 24" fill="#0e1726" width="200px" height="200px"><g><rect fill="none" height="24" width="24"/></g><g><g><g><circle cx="7" cy="7" r="2"/></g><g><path d="M20,13V4.83C20,3.27,18.73,2,17.17,2c-0.75,0-1.47,0.3-2,0.83l-1.25,1.25C13.76,4.03,13.59,4,13.41,4 c-0.4,0-0.77,0.12-1.08,0.32l2.76,2.76c0.2-0.31,0.32-0.68,0.32-1.08c0-0.18-0.03-0.34-0.07-0.51l1.25-1.25 C16.74,4.09,16.95,4,17.17,4C17.63,4,18,4.37,18,4.83V13h-6.85c-0.3-0.21-0.57-0.45-0.82-0.72l-1.4-1.55 c-0.19-0.21-0.43-0.38-0.69-0.5C7.93,10.08,7.59,10,7.24,10C6,10.01,5,11.01,5,12.25V13H2v6c0,1.1,0.9,2,2,2c0,0.55,0.45,1,1,1 h14c0.55,0,1-0.45,1-1c1.1,0,2-0.9,2-2v-6H20z"/></g></g></g></svg>

                                            </center>
                                    </div>
                                </div>
                                <br>
                                <div class="row">
                                    <div class="col-md-12"><center><h4>Equipamiento de la habitación</h4></center><br></div>

                                    @foreach($ser_habitacion as $key)
                                        <div class="col-md-6">
                                            <label class="switch s-outline s-primary mr-2" style="display: inline-block; margin-bottom: 0px">
                                                <input type="checkbox" name="servicios[]" value="{{$key->id}}"
                                                <?php 
                                                    if (in_array($key->id, $equipos,false)) {
                                                         echo "checked='checked'";
                                                    }
                                                 ?>
                                                >
                                                <span class="slider round"></span>
                                            </label>
                                            <h5 style="display: inline-block; padding: 0px;">{{$key->equipo}}</h5><br>
                                        </div>
                                    @endforeach

                                </div>
                                <br>  
                                
                                <div class="row">
                                     <div class="col-md-6">
                                        <h6>Precio en Q <strong class="text-danger">*</strong></h6>
                                        <input type="number" name="precio_q" class="form-control precio_q mb-1" placeholder="Precio en Quetzal" min="0.01" step="0.01" id="precio_q" value="{{$habitacion->precios[1]->precio}}"  required="required">

                                        <div class="row">
                                            <div class="col-md-12">
                                                <h6 class="mt-1">Impuestos en porcentaje (%) <strong class="text-danger">*</strong></h6>
                                            </div>
                                            <div class="col-md-3">
                                                <br>
                                                <h6>IVA</h6>
                                                <input type="number" name="iva_q" class="form-control precio_q" placeholder="Ej. 5%"  min="0.01" step="0.01" max="50" id="iva_q" value="{{$habitacion->precios[1]->IVA}}">
                                            </div>
                                            <div class="col-md-4">
                                                <br>
                                                <h6>ISR </h6>
                                                <input type="number" name="isr_q" class="form-control precio_q" placeholder="Ej. 12%"  min="0.01" step="0.01" max="50" id="isr_q" value="{{$habitacion->precios[1]->ISR}}">
                                            </div>
                                            <div class="col-md-5" style="margin-top: -30px;">
                                                <br>
                                                <h6>¿Pagas el INGUAT? <strong class="text-danger">*</strong></h6>
                                                <div class="n-chk" style="display: inline-block;">
                                                <label class="new-control new-radio new-radio-text radio-classic-primary">
                                                  <input type="radio" class="new-control-input" name="impuesto_inguat_q" value="S" required="required" onclick="impuesto_inguat('impuesto_inguat_q',1);"
                                                  @if(is_null($habitacion->precios[1]->INGUAT)==false)
                                                    checked="checked"
                                                  @endif
                                                  >
                                                  <span class="new-control-indicator"></span><span class="new-radio-content">Si</span>
                                                </label>
                                            </div>
                                            <div class="n-chk" style="display: inline-block;">
                                                <label class="new-control new-radio precio_q new-radio-text radio-classic-primary">
                                                  <input type="radio" class="new-control-input" name="impuesto_inguat_q" value="N"  required="required"
                                                  onclick="impuesto_inguat('impuesto_inguat_q',1);"
                                                  
                                                  @if(is_null($habitacion->precios[1]->INGUAT))
                                                    checked="checked"
                                                  @endif  
                                                  >
                                                  <span class="new-control-indicator"></span><span class="new-radio-content">No</span>
                                                </label>
                                            </div>
                                                <input type="number" name="inguat_q" class="form-control precio_q" placeholder="Ej. 10%" min="0.01" step="0.01" max="50" required="required" id="inguat_q" 
                                                @if(is_null($habitacion->precios[1]->INGUAT))
                                                    disabled="disabled"
                                                @endif                                                
                                                value="{{$habitacion->precios[1]->INGUAT}}">
                                            </div>

                                            <div class="col-md-6">
                                                <br>
                                                <h6>¿Oferta? <small>En porcentaje</small></h6>
                                                <input type="number" name="oferta_q" class="form-control precio_q" placeholder="Ej. 10%" min="0" step="0.01" max="50" id="oferta_q" value="{{$habitacion->precios[1]->oferta}}">    
                                            </div>

                                            <div class="col-md-6">
                                                <br>
                                                <h6>Total en Q</h6>
                                                <div id="total_q">
                                                    <h4>{!!$html_precio_q!!}</h4>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <h6>Precio en USD <strong class="text-danger">*</strong></h6>
                                        <input type="number" name="precio_usd" class="form-control precio_usd" placeholder="Precio en dolar (USD)" min="0.01" step="0.01" id="precio_usd" value="{{$habitacion->precios[0]->precio}}"  required="required">

                                        <div class="row">
                                            <div class="col-md-12">
                                                <h6 class="mt-1">Impuestos en porcentaje (%) <strong class="text-danger">*</strong></h6>
                                            </div>
                                            <div class="col-md-3">
                                                <br>
                                                <h6>IVA</h6>
                                                <input type="number" name="iva_usd" class="form-control precio_usd" placeholder="Ej. 13%" min="0.01" step="0.01" max="50" id="iva_usd" value="{{$habitacion->precios[0]->IVA}}">
                                            </div>
                                            <div class="col-md-4">
                                                <br>
                                                <h6>ISR</h6>
                                                <input type="number" name="isr_usd" class="form-control precio_usd" placeholder="Ej. 12%" min="0.01" step="0.01" max="50" id="isr_usd" value="{{$habitacion->precios[0]->ISR}}">
                                            </div>
                                            <div class="col-md-5" style="margin-top: -30px;">
                                                <br>
                                                <h6>¿Pagas el INGUAT? <strong class="text-danger">*</strong></h6>
                                                <div class="n-chk" style="display: inline-block;">
                                                <label class="new-control new-radio new-radio-text radio-classic-primary">
                                                  <input type="radio" class="new-control-input" name="impuesto_inguat_usd" value="S" required="required" onclick="impuesto_inguat('impuesto_inguat_usd',2);"
                                                  @if(is_null($habitacion->precios[0]->INGUAT)==false)
                                                    checked="checked" 
                                                    @endif
                                                  >
                                                  <span class="new-control-indicator"></span><span class="new-radio-content">Si</span>
                                                </label>
                                            </div>
                                            <div class="n-chk" style="display: inline-block;">
                                                <label class="new-control new-radio new-radio-text radio-classic-primary impuesto_inguat_usd">
                                                  <input type="radio" class="new-control-input" name="impuesto_inguat_usd" value="N"  required="required" onclick="impuesto_inguat('impuesto_inguat_usd',2);"

                                                   @if(is_null($habitacion->precios[0]->INGUAT))
                                                    checked="checked" 
                                                    @endif    
                                                  >
                                                  <span class="new-control-indicator"></span><span class="new-radio-content">No</span>
                                                </label>
                                            </div>
                                                <input type="number" name="inguat_usd" class="form-control precio_usd" placeholder="Ej. 10%" min="0.01" step="0.01" max="50" required="required" id="inguat_usd" value="{{$habitacion->precios[0]->INGUAT}}"
                                                @if(is_null($habitacion->precios[0]->INGUAT))
                                                    disabled="disabled"
                                                @endif    >
                                            </div>

                                            <div class="col-md-6">
                                                <br>
                                                <h6>¿Oferta? <small>En porcentaje</small></h6>
                                                <input type="number" name="oferta_usd" class="form-control precio_usd" placeholder="Ej. 10%" min="0" step="0.01" max="99" id="oferta_usd" value="{{$habitacion->precios[0]->oferta}}">    
                                            </div>


                                            <div class="col-md-6">
                                                <br>
                                                <h6>Total en USD</h6>
                                                <div id="total_usd">
                                                    <h4>{!!$html_precio_usd!!}</h4>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <br><br>

                                <div class="container">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <center>
                                                <h4>Camas de la habitación</h4>
                                                <p>
                                                    Coloque la cantidad de camas disponibles en esta habitación 
                                                </p> <br>
                                            </center>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <?php $cont_cama = 0; ?>
                                        @foreach($tipos_camas as $key)
                                            <div class="col-md-3">
                                                <h6>{{$key->cama}}</h6>
                                                <input type="number" name="cama_{{$key->id}}" id="cama-{{$key->id}}" min="0" class="form-control cama" required="required" value="<?php 
                                                        echo $habitacion->camas[$cont_cama]->cantidad;
                                                    ?>">
                                                <br>
                                            </div>
                                            <?php $cont_cama++; ?>
                                        @endforeach 
                                    </div>
                                </div>
                                <br>

                                <div class="row">

                                    <div class="col-md-6">
                                        <h6>N° Húesped</h6>
                                        <input type="number" min="1" name="huesped" class="form-control" value="{{$habitacion->huesped}}" id="huesped"><br>
                                    </div>

                                    <div class="col-md-6">
                                        <h6> Habitaciones iguales a esta <strong class="text-danger">*</strong></h6>
                                        <input type="number" min="1" name="cantidad" class="form-control" placeholder="Número de habitaciones disponibles" value="{{$habitacion->cantidad}}"><br>
                                    </div>
                                    <div class="col-md-6">
                                        <h6> Tamaño en metros cuadrados de la habitación <strong class="text-danger">*</strong></h6>
                                        <input type="number" min="1" name="size" class="form-control" placeholder="Ej 20m" step="0.01" value="{{$habitacion->size}}"><br>
                                    </div>
                                    <div class="col-md-6">
                                        <h6>Publicar <strong class="text-danger">*</strong></h6>
                                        <select class="form-control" name="publicar" required="required">
                                            <option value="">Seleccione una opción</option>
                                            <option value="S" @if($habitacion->publicado == 'S') selected="selected" @endif>Si</option>
                                            <option value="N" @if($habitacion->publicado == 'N') selected="selected" @endif>No</option>
                                        </select>
                                    </div>
                                </div>
                                <br>
                                <div class="row">
                                    <div class="col">
                                        <h6>Descripción <strong class="text-danger">*</strong></h6>
                                        <textarea class="form-control" placeholder="Describa la respuesta de la pregunta" name="descripcion" id="respuesta">{{$habitacion->descripcion}}</textarea><br>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col">
                                        <button type="submit" class="btn btn-primary float-right">Actualizar</button>
                                    </div>
                                </div>
                                <input type="hidden" name="total" id="total" value="1">

                                <?php $i=0; ?>
                            </form>                                         
                        </div>
                    </div>
                </div>         
            </div>
        </div>
    </div>
</div>
@endsection

@section('script')
    <script type="text/javascript" src="{{asset('js/ckeditor/ckeditor.js')}}"></script>
    <script type="text/javascript">
        CKEDITOR.replace('respuesta');
    </script>

    <script type="text/javascript">
        var df_img = '<?php echo asset('img/img.png') ?>';
        var df_route_cargar = '<?php echo route('habitaciones.fotos'); ?>';
        var df_route_eliminar = '<?php echo route("habitaciones.fotos.delete"); ?>';
        var id_foto = <?php echo $nro_fotos + 1; ?>;
        var cont_delete = <?php echo $nro_fotos;?>;
    </script>

<script type="text/javascript" src="{{asset('js/fotos.js')}}"></script>
<script type="text/javascript">

    $('.cama').change(function(){
        var cama1 = $('#cama-1').val();
        var cama2 = $('#cama-2').val();
        var cama3 = $('#cama-3').val();
        var cama4 = $('#cama-4').val();

        if (cama1 <0) {
            cama1 = 1;
            $('#cama-1').val(1);
        }

        if (cama2 <0) {
            cama2 = 1;
            $('#cama-2').val(1);
        }

        if (cama3 <0) {
            cama3 = 1;
            $('#cama-3').val(1);
        }

        if (cama4 <0) {
            cama4 = 1;
            $('#cama-4').val(1);
        }

        cama1 = parseInt(cama1) * 1;
        cama2 = parseInt(cama2) * 2;
        cama3 = parseInt(cama3) * 2;
        cama4 = parseInt(cama4) * 1;

        var suma = cama1+cama2+cama3+cama4;

        $('#huesped').val(suma);

    });

     function impuesto_inguat(name,number){
        console.log('OK');
        var dato = $('input:radio[name='+name+']:checked').val();
    
        if (number==1) {
            if (dato=='S') {
                $('#inguat_q').prop('disabled',false);
            }else{
                $('#inguat_q').prop('disabled',true);
            }

        }else{
            if (dato=='S') {
                $('#inguat_usd').prop('disabled',false);
            }else{
                $('#inguat_usd').prop('disabled',true);
            }
        }

        
    }

    $('.precio_q').keyup(function(){

        var precio = $('#precio_q').val();
        var iva = $('#iva_q').val();
        var isr = $('#isr_q').val();
        var inguat = $('#inguat_q').val();
        var oferta = $('#oferta_q').val();

        if (precio == '') {
            precio = 0;
        }

        if (iva == '') {
            iva = 0;
        }

        if (isr == '') {
            isr = 0;
        }

        if (inguat == '') {
            inguat = 0;
        }

        if (oferta == '') {
            oferta = 0;
        }

        var precio = parseFloat(precio);
        var valor_iva =  parseFloat((iva* precio) / 100);
        var valor_isr =  parseFloat((isr* precio) / 100);
        var valor_inguat = parseFloat((inguat* precio) / 100);

        var total = precio + valor_iva + valor_isr +  valor_inguat;

        if (oferta==0) {
            $('#total_q').html(`<h4>Q.${total.toFixed(2)}</h4>`);
        }else{
            var oferta = parseFloat(oferta);

            oferta = (oferta * total)/100;

            var total_oferta = total - oferta;

            $('#total_q').html(`<h4> <small class="mr-3"><strike>Q.${total.toFixed(2)} </strike></small> Q${total_oferta.toFixed(2)}</h4>`);
        }

        

        //
    });

     $('.precio_usd').keyup(function(){

        var precio = $('#precio_usd').val();
        var iva = $('#iva_usd').val();
        var isr = $('#isr_usd').val();
        var inguat = $('#inguat_usd').val();
        var oferta = $('#oferta_usd').val();
            
        if (precio == '') {
            precio = 0;
        }

        if (iva == '') {
            iva = 0;
        }

        if (isr == '') {
            isr = 0;
        }

        if (inguat == '') {
            inguat = 0;
        }

        if (oferta == '') {
            oferta = 0;
        }

        var precio = parseFloat(precio);
        var valor_iva =  parseFloat((iva* precio) / 100);
        var valor_isr =  parseFloat((isr* precio) / 100);
        var valor_inguat = parseFloat((inguat* precio) / 100);

        var total = precio + valor_iva + valor_isr +  valor_inguat;

        
        if (oferta==0) {
            $('#total_usd').html(`<h4>$.${total.toFixed(2)}</h4>`);
        }else{
            var oferta = parseFloat(oferta);

            oferta = (oferta * total)/100;

            var total_oferta = total - oferta;

            $('#total_usd').html(`<h4> <small class="mr-3"><strike>Q.${total.toFixed(2)} </strike></small> $.${total_oferta.toFixed(2)}</h4>`);
        }
    });

</script>

@endsection