@extends('layouts.app')

@section('content')        

        <section class="pt-md-4 pb-md-0" style="
                        height: 600px;
                        background: 
                        linear-gradient(
                          rgba(0, 0, 0, 0.6), 
                          rgba(0, 0, 0, 0.6)
                        ),
                        /* bottom, image */
                        url('{{asset($banner->data)}}');
                        background-size: 100% 100%;
                        background-repeat: no-repeat;">
          <div class="container">
            <div class="row justify-content-between align-items-center">
              <div class="col-lg-8 col-md-9">
                <div class="d-none d-md-block">
                  <br><br><br>
                </div>
                <h4 class="display-3 d-none d-md-block" style="color: white;">La manera más fácil de encontrar un hotel en Guatemala</h4>
                <h4 class="d-block d-md-none" style="color: white;">La manera más fácil de encontrar un hotel en Guatemala</h4>

                <p class="lead"></p>           
              </div>
              <div class="col-md-3 d-none d-md-block">
                <img src="{{asset('img/guatehoteles.png')}}" style="width: 1000px;" alt="Image">
              </div>
            </div>
            <form action="{{asset('/hoteles')}}" method="GET">
                <div class="row">
                    <div class="col-12 col-md-2">
                       <label style="margin: 0px; color: white;">Departamento</label>
                       <select class="form-control" name="departamento" id="departamento" required="required">
                           <option value="">Selecciona una opción</option>
                           @foreach($departamentos as $key)
                            <option value="{{$key->id}}">{{$key->departamento}}</option>
                           @endforeach
                       </select><br>
                    </div>
                    <div class="col-12 col-md-2">
                       <label style="margin: 0px; color: white;">Municipio</label>
                       <select class="form-control" name="municipio" id="municipio">
                           <option value="">Selecciona una opción</option>
                       </select><br>
                    </div>
                    <div class="col-12 col-md-3">
                        <label style="margin: 0px; color: white;">Fecha de llegada</label>
                        <input type="date" name="check_in" class="form-control" required="required"><br>
                    </div>
                    <div class="col-12 col-md-3">
                        <label style="margin: 0px; color: white;">Fecha de salida</label>
                        <input type="date" name="check_out" class="form-control" required="required"><br>
                    </div>
                    <div class="col-12 col-md-1">
                        <label style="margin: 0px; color: white;">Huésped</label>
                        <input type="number" name="huesped" class="form-control" id="huesped" value="1" required="required" min="1"><br>
                    </div>
                    <div class="col-12 col-md-1">
                        <br>
                        <input type="hidden" name="a" value="1" id="form-a">
                        <input type="hidden" name="n" value="0" id="form-n">
                        <center><button class="btn btn-primary" type="submit">Buscar</button></center>
                    </div>
                </div>
                <div style="display: none;" id="form-edad">
                  
                </div>
            </form>            
          </div>
        </section>

        @if($hoteles_guatehoteles->count() != 0)
          <section class="o-hidden" style="background: linear-gradient(90deg, #0099FF 0%, #6610f2 100%);
          max-height: 800px;
          ">
            <div class="container">
              <div class="row mb-4">
                <div class="col">
                  <span class="h2 text-white">Hoteles recomendados por nosotros</span>
                </div>
              </div>
            </div>
            <div data-flickity="{ &quot;cellAlign&quot;:&quot;@if($hoteles_guatehoteles->count()< 4) false @else true @endif&quot;,&quot;autoPlay&quot;: true, &quot;contain&quot;: true, &quot;imagesLoaded&quot;: true, &quot;wrapAround&quot;: true }" class="controls-light slider-highlight-selected">
            @foreach($hoteles_guatehoteles as $key)
              <div class="col-12 col-md-4 col-lg-3 pt-3">
                  @include('layouts.cardhoteles')
              </div>
            @endforeach            
            </div>
          </section>
        @endif

        @if($hoteles_inguat->count() != 0)
        <section>
          <center><h1>Hoteles reconocidos por Inguat</h1></center>
          <hr>

          <div class="container">
            <div class="row">
             @foreach($hoteles_inguat as $key)
              <div class="col-md-3">
                @include('layouts.cardhoteles')
              </div>
              @endforeach
            </div>
          </div>

        </section>
        @endif

        <section style="background: #152a49;">
          <center><h1 class="text-white">Encuentra hoteles según tu destino</h1></center>
          <hr>

          <div class="container0" style="padding: 30px;">
            <div class="row">
             @foreach($departamentos as $key)
              <div class="col-md-3">
                <div class="card">
                  <img class="card-img-top" src="{{asset($key->img)}}" alt="{{$key->departamento}}" style="min-height: 133.5px; max-height: 133.5px;" />
                  <div class="card-body py-3">
                    <h5>{{$key->departamento}}</h5><hr>
                    <div style="min-height: 150px; max-height: 150px;overflow: auto;font-size: 14px;">
                      @foreach($key->municipios as $key2)                         
                        <div class="row" style="padding: 0;margin: 0px;">
                          <div class="col-10" style="font-size: 13px;">{{$key2->municipio}}</div>
                          <div class="col-2"  style="font-size: 13px;"> <span>{{$key2->n_hoteles()}}</span></div>
                        </div>
                      @endforeach
                    </div>
                  </div>
                  <div class="card-footer">
                    <div class="d-flex align-items-center justify-content-between">
                        <a href="{{asset('hoteles')}}?departamento={{$key->id}}">Ver todos</a>                        
                        <i class="material-icons text-dark">keyboard_arrow_right</i>
                    </div>
                  </div>
                </div>
              </div>
              @endforeach
            </div>
          </div>

        </section>

@endsection

@section('script')
    <script type="text/javascript">
    var departamentos = [
      <?php 
        foreach ($departamentos as $key) {
          echo "
            {
              id:".$key->id.',
              municipios:[              
            ';

            foreach ($key->municipios as $key2) {
              echo "
                {
                  id:".$key2->id.",
                  municipio: '".$key2->municipio."'
                },
              ";
            }

            echo "]},";
        }
      ?>
    ];

    $('#departamento').change(function(){

      var value = $(this).val();

      if (value=='') {

        var option = '<option value="">Selecciona una opción</option>';
        $('#municipio').html(option);

      }else{
        var option = '<option value="">Selecciona una opción</option>';

        var municipios = departamentos[value - 1].municipios;

        municipios.forEach(function(element){
          option = option + '<option value="'+element.id+'">'+element.municipio+'</option>';
        });

        $('#municipio').html(option);
      }
    });    

  </script>
@endsection