        <nav class="navbar navbar-expand-lg navbar-dark bg-dark py-0">
          <div class="container">
            <div class="collapse navbar-collapse navMenu justify-content-between">
              <div class="d-flex justify-content-end justify-content-lg-start pt-1 pt-lg-0">
                <div class="dropdown">
                  <button class="btn dropdown-toggle btn-dark btn-sm" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    <img src="{{asset(session('moneda_img')) }}" alt="Dolar" class="btn-image">
                    <span>Moneda: {{session('moneda_simbolo')}}</span>
                  </button>
                  <div class="dropdown-menu">
                    @foreach($monedas as $key)
                      <a class="dropdown-item" href="{{route('moneda',$key->id)}}">{{$key->simbolo}} ({{$key->moneda}})</a>
                    @endforeach
                  </div>
                </div>
              </div>
              <div class="py-1 d-flex align-items-center justify-content-end">
                @auth  
                  @if(Auth::user()->rol_id!=3)
                    <a href="{{route('home')}}" class="btn btn-primary btn-sm mr-2">Ir al panel</a> 
                  @endif 

                  <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
                    @csrf
                  </form>

                  <div class="dropdown">
                    <button class="btn btn-secondary btn-sm dropdown-toggle mr-2" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                      {{Auth::user()->name}}
                    </button>
                    <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                      <a class="dropdown-item" href="{{route('favoritos.index')}}">Favoritos</a>
                      <a class="dropdown-item" href="{{route('user.cuenta')}}">Mi cuenta</a>
                      <a class="dropdown-item" href="{{route('user.clave')}}">Cambiar contraseña</a>
                      <a class="dropdown-item" href="#" onclick="event.preventDefault();
                            document.getElementById('logout-form').submit();">Cerrar sesión</a>
                    </div>
                  </div>
                                  
                @else
                  <ul class="navbar-nav d-flex flex-row">
                    <li class="nav-item">
                      <a href="{{route('login')}}" class="text-small nav-link px-2">Iniciar Sesión</a>
                    </li>
                  </ul>
                  <a href="{{route('register')}}" class="btn btn-primary btn-sm">Registrar</a>
                @endauth
              </div>
            </div>
          </div>
        </nav>
        <nav class="navbar navbar-expand-lg navbar-light bg-white sticky-top" style="box-shadow: 0 0 5px grey">
          <div class="container">
            <a class="navbar-brand" href="{{asset('')}}">
              <img alt="GuateHoteles" src="{{asset('img/logo.png')}}" style="max-width: 100%; max-height: 50px;">
            </a>
            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target=".navMenu" aria-expanded="false" aria-label="Toggle navigation">
              <span class="navbar-toggler-icon"></span>
            </button>

            <div class="collapse navbar-collapse justify-content-end navMenu">

              <ul class="navbar-nav">

                <li class="nav-item">
                  <a class="nav-link {{ request()->is('/') ? 'active' : ' ' }}" href="{{asset('')}}">Inicio</a>
                </li>

                <li class="nav-item">
                  <a href="{{asset('hoteles')}}" class="nav-link {{ request()->is('hoteles') ? 'active' : ' ' }} {{ request()->is('hotel/*') ? 'active' : ' ' }}">Hoteles</a>
                </li>

                <li class="nav-item">
                  <a class="nav-link {{ request()->is('quienes-somos') ? 'active' : ' ' }}" href="{{route('portal.quienes-somos')}}">Quiénes somos</a>
                </li>

                <li class="nav-item">
                  <a class="nav-link {{ request()->is('preguntas-frecuentes') ? 'active' : ' ' }}" href="{{route('portal.preguntas')}}">Preguntas frecuentes</a>
                </li>

                <li class="nav-item">
                  <a class="nav-link {{ request()->is('contacto') ? 'active' : ' ' }}" href="{{route('portal.contacto')}}">Soporte</a>
                </li>

              </ul>
            </div>
          </div>
        </nav>