@extends('layouts.app')

@section('content')

    <style type="text/css">
    @media (min-width: 992px){
      .modal-lg {
          max-width: 1140px;
      }
    }
    
    .loader,
    .loader:after {
      border-radius: 50%;
      width: 10em;
      height: 10em;
    }
    .loader {
        margin: 60px auto;
        font-size: 10px;
        position: relative;
        text-indent: -9999em;
        border-top: 1.1em solid #2196F3;
        border-right: 1.1em solid #2196F3;
        border-bottom: 1.1em solid rgb(0 0 0 / 20%);
        border-left: 1.1em solid #2196F3;
        -webkit-transform: translateZ(0);
        -ms-transform: translateZ(0);
        transform: translateZ(0);
        -webkit-animation: load8 1.1s infinite linear;
        animation: load8 1.1s infinite linear;
    }
    @-webkit-keyframes load8 {
      0% {
        -webkit-transform: rotate(0deg);
        transform: rotate(0deg);
      }
      100% {
        -webkit-transform: rotate(360deg);
        transform: rotate(360deg);
      }
    }
    @keyframes load8 {
      0% {
        -webkit-transform: rotate(0deg);
        transform: rotate(0deg);
      }
      100% {
        -webkit-transform: rotate(360deg);
        transform: rotate(360deg);
      }
    }

  </style>
  
  <div class="modal fade" id="codigo" data-backdrop="static" data-keyboard="false" tabindex="-1" role="dialog" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="habitacion_title"></h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body" id="codigo_body">
          
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" id="cerrar-code" data-dismiss="modal">Cerrar</button>
        </div>
      </div>
    </div>
  </div>

  <div class="p-2">
    <div class="row">
      <div class="col-md-6">
        <div class="card box-shadow">
          <div class="card-body">
            <center><h4 class="mt-2">Proceso de reclamación del hotel</h4></center>
            <div class="ml-3">
              <h4 class="mt-2 mb-0 pb-0">{{$hotel->nombre}}</h4>
              @for($e=0;$e<$hotel->estrellas;$e++)
                <i class="material-icons text-warning" style="display: inline-block; font-size: 18px;">star</i>
              @endfor
              <br>
              <div class="text-primary">
                <i class="material-icons"style="font-size: 18px;" >location_on</i> 
                <p id="text-ubicacion" style="display: inline-block;">
                  {{$hotel->ubicacion->municipio->municipio}} -
                  {{$hotel->ubicacion->departamento->departamento}}
                </p>
              </div>
            </div>
            <hr>
            <div>              
              <div style="text-align: right; width: 100%;">
                <form action="{{route('hotel.reclamar',$hotel->id)}}" method="post">
                  @csrf
                  <div id="correo">
                    <center><h4>Seleccione una dirección de correo electrónico </h4></center>
                    <ul class="list-group">

                      @foreach($hotel->contactos as $key)
                        @if(is_null($key->email)==false)
                            <li class="list-group-item">
                              <div class="d-flex justify-content-between align-items-center">
                                  <a class="d-flex align-items-center flex-fill" href="#" data-toggle="collapse" data-target="#accordion-panel-{{$key->id}}">
                                      <span class="mb-0 text-primary py-1 font-weight-bold">{{$key->email}}</span>
                                  </a>
                                  <i class="material-icons d-block text-dark">keyboard_arrow_right</i>
                              </div>
                              <div id="accordion-panel-{{$key->id}}" class="collapse">
                                  <div class="pt-1" style="text-align: justify;">
                                      Enviaremos un código de un solo uso a la siguiente dirección de correo electrónico <strong>{{$key->email}}</strong>
                                      <div style="width: 100%; text-align: right;">
                                        <div class="mt-3">
                                          <button type="button" class="btn btn-primary" onclick="enviar('{{$key->id}}');">Obtener el código</button>
                                        </div>
                                      </div>
                                  </div>
                              </div>
                          </li>
                        @endif
                      @endforeach

                    </ul>
                  </div>
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div class="col-md-6">
        <center><img class="imagen-responsive d-none d-md-block mt-5 mb-3" src="{{asset('img/guatehoteles.png')}}"></center>
      </div>
    </div>
  </div>
@endsection

@section('script')
  <script type="text/javascript">
    function enviar(id){


      $('#cerrar-code').css({'display':'block'});
      $('#codigo_body').html(`
        <center>
            <div class="loader">Loading...</div>
            <h4 class="mt-2">Enviando código … </h4>
          </center>`);
      $('#codigo').modal('show');

      $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')     
        }
      }); 

      $.ajax({
        url:'<?php echo route('hotel.codigo'); ?>',       
        type:'post',  
        data:{
          id_email: id ,
          id_hotel: <?php echo $hotel->id; ?>
        },   
        success: function (response) {  
          $('#cerrar-code').css({'display':'none'});        
          $('#codigo_body').html(`           
            <div>
              <h6>Por favor, ingrese el código a continuación: </h6>
              <input type="text" name="codigo" id="codigo_input" class="form-control" placeholder="123456789...">
              <div style="width: 100%; text-align: right;">
                <button class="btn btn-primary mt-1" onclick="validar()">Validar</button>
              </div>
            </div>
            `);                                     
        }
      });
    }

    function validar(){
      var code = $('#codigo_input').val();

      $('#codigo_body').html(`
        <center>
            <div class="loader">Loading...</div>
            <h4 class="mt-2">Validando el código … </h4>
          </center>`);
      $('#codigo').modal('show');

      $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')     
        }
      }); 

      $.ajax({
        url:'<?php echo route('hotel.validar'); ?>',       
        type:'post',  
        data:{
          id_hotel: <?php echo $hotel->id; ?>,
          code: code,
        },   
        success: function (response) {  
          if (response==1) {
            $('#codigo_body').html(`           
            <div>
              <div class="alert alert-danger" role="alert">
                El código que ingresó no es válido, por favor intente de nuevo
              </div>
              <h6>Por favor, ingrese el código a continuación: </h6>
              <input type="text" name="codigo" id="codigo_input" class="form-control" placeholder="123456789..." value='${code}'>
              <div style="width: 100%; text-align: right;">
                <button class="btn btn-primary mt-1" onclick="validar()">Validar</button>
              </div>
            </div>
            `);    
          }else{
            $('#codigo_body').html(`           
            <div>
              <div class="alert alert-success" role="alert">
                Código validado correctamente 
              </div>
            </div>
            `); 
            window.location = '{{route("hoteles.propios")}}';
          }                              
        }
      });

    }
  </script>
@endsection