@extends('admin.layouts.app')

@section('breadcrumb')
    <li class="breadcrumb-item" aria-current="page"><a href="{{route('servicios.index')}}">Servicios</a></li>
    <li class="breadcrumb-item" aria-current="page"><span>Subservicio</span></li>
    <li class="breadcrumb-item active" aria-current="page"><span>Editar</span></li>
@endsection

@section('css')

@endsection

@section('content')
<div class="row layout-spacing layout-top-spacing feather-icon">
    <div id="font-icon_feather" class="col-lg-12">
        <div class="statbox widget box box-shadow">
            <div class="widget-content widget-content-area bx-top-6">
                <div class="icon-section">
                    <div class="row">
                        <div class="col-xl-12">
                        	<a href="{{ route('subservicios.index',$id_servicio) }}" class="ml-1 mr-2 btn btn-dark float-left rounded-circle bs-tooltip" 
                                        data-toggle="tooltip" data-placement="bottom"
                                        title="Volver">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-chevron-left"><polyline points="15 18 9 12 15 6"></polyline></svg>
                                    </a>
                            <center><h4>Editar subservicio</h4></center>
                            <hr>

                            <form action="{{route('subservicios.update',[$id_servicio,$servicio->id])}}" method="post" enctype="multipart/form-data">
                                @csrf

                                <div class="row">
                                    <div class="col">
                                        <h6>Nombre del servicio <strong class="text-danger">*</strong></h6>
                                        <input type="text" name="servicio" class="form-control  @if(session('error_servicio')) is-invalid @endif" placeholder=" Ej. WiFI"  value="{{$servicio->servicio}}">
                                        <div class="invalid-feedback">
                                               @if(session('error_servicio')) {{session('error_servicio')}} @endif
                                            </div>
                                       <br>
                                    </div>
                                </div>


                                <div class="row">
                                    <div class="col">
                                        <button type="submit" class="btn btn-primary float-right">Editar</button>
                                    </div>
                                </div>
                            </form>                                         
                        </div>
                    </div>
                </div>         
            </div>
        </div>
    </div>
</div>
@endsection
