<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateHabitacionesCamasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('habitaciones_camas', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('id_habitacion');
            $table->foreign('id_habitacion')->references('id')->on('habitaciones')->onDelete('cascade');

            $table->unsignedBigInteger('id_tipo_cama');
            $table->foreign('id_tipo_cama')->references('id')->on('tipos_camas')->onDelete('cascade');

            $table->integer('cantidad');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('habitaciones_camas');
    }
}
