<!DOCTYPE html>
<html lang="es">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
        <title><?php echo e($titulo->data); ?></title>

        <meta name="description" content="<?php echo e($descripcion->data); ?>"/>

        <link href="https://fonts.googleapis.com/css?family=Nunito:200,600" rel="stylesheet">
        <link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/theme.css')); ?>">
        <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
        <link href="https://fonts.googleapis.com/css?family=Nunito:400,400i,600,600i,700,700i%7cPermanent+Marker" rel="stylesheet">
        <link rel="stylesheet" href="<?php echo e(asset('css/fullscreen.css')); ?>">
        <?php echo $__env->yieldContent('styles'); ?>
        <?php echo NoCaptcha::renderJs(); ?>

    </head>
    <body>
        <?php echo $__env->make('layouts.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


        <?php echo $__env->yieldContent('content'); ?>


        <?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="modal fade" tabindex="-1" id="modal-huesped">
          <div class="modal-dialog modal-sm">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title">Huésped</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body">
                <form action="#">
                    <div class="row">
                        <div class="col-md-6">
                            <h6>Adultos</h6>
                            <input type="number" name="a" class="form-control" min="0" required="required" id="huesped-a"
                                <?php if (isset($data_hoteles)) {
                                    echo "value='".$data_hoteles['a']."'";
                                }else{
                                    echo "value='1'";
                                } ?>
                            ><br>
                        </div>
                        <div class="col-md-6">
                            <h6>Niños</h6>
                            <input type="number" name="n" class="form-control" min="0" required="required"
                             id="huesped_n"
                                <?php if (isset($data_hoteles)) {
                                    echo "value='".$data_hoteles['n']."'";
                                }else{
                                    echo "value='0'";
                                } ?>
                             ><br>
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="row" id="huesped-edad">
                            <?php if(isset($data_hoteles)): ?>
                                <?php if(is_array($data_hoteles['edad'])): ?>
                                    <?php $__currentLoopData = $data_hoteles['edad']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                          <div class="col-md-12">
                                            <h6>Edad del menor <strong class="text-danger">*</strong></h6>
                                              <select class="form-control edad-menor" name="edad[]" required="required">
                                                <option value="">Edad</option>
                                                <?php for($i=0;$i<=17;$i++): ?>
                                                    <option value="<?php echo e($i); ?>"
                                                    <?php if ($key == $i) {
                                                        echo 'selected="selected"';
                                                    } ?>
                                                    ><?php echo e($i); ?></option>
                                                <?php endfor; ?>
                                              </select><br>
                                           </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </form>
              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
                <button type="button" class="btn btn-primary" onclick="huesped_guardar();">Guardar</button>
              </div>
            </div>
          </div>
        </div>

        <script type="text/javascript" src="<?php echo e(asset('js/jquery-3.2.1.min.js')); ?>"></script>
        <script type="text/javascript" src="<?php echo e(asset('js/popper.min.js')); ?>"></script>
        <script type="text/javascript" src="<?php echo e(asset('js/bootstrap.min.js')); ?>"></script>
        <script type="text/javascript" src="<?php echo e(asset('js/prism.min.js')); ?>"></script>
        <script type="text/javascript" src="<?php echo e(asset('js/scrollMonitor.js')); ?>"></script>
        <script type="text/javascript" src="<?php echo e(asset('js/smooth-scroll.polyfills.min.js')); ?>"></script>
        <script type="text/javascript" src="<?php echo e(asset('js/zoom-vanilla.min.js')); ?>"></script>
        <script type="text/javascript" src="<?php echo e(asset('js/jquery.countdown.min.js')); ?>"></script>
        <script type="text/javascript" src="<?php echo e(asset('js/clipboard.min.js')); ?>"></script>
        <script type="text/javascript" src="<?php echo e(asset('js/jquery.smartWizard.js')); ?>"></script>
        <script type="text/javascript" src="<?php echo e(asset('js/flickity.pkgd.min.js')); ?>"></script>
        <script type="text/javascript" src="<?php echo e(asset('js/isotope.pkgd.min.js')); ?>"></script>
        <script type="text/javascript" src="<?php echo e(asset('js/theme.js')); ?>"></script>
        <script src="<?php echo e(asset('js/fullscreen.js')); ?>"></script>
        <script src="<?php echo e(asset('js/buscador.js')); ?>"></script>

         <?php echo $__env->yieldContent('script'); ?>
    </body>
</html>
<?php /**PATH /home/guatehoteles/test.guatehoteles.com/resources/views/layouts/app.blade.php ENDPATH**/ ?>