

<?php $__env->startSection('content'); ?>
   <style type="text/css">
    @media (min-width: 992px){
      .modal-lg {
          max-width: 1140px;
      }
    }
    
    .loader,
    .loader:after {
      border-radius: 50%;
      width: 10em;
      height: 10em;
    }
    .loader {
        margin: 60px auto;
        font-size: 10px;
        position: relative;
        text-indent: -9999em;
        border-top: 1.1em solid #2196F3;
        border-right: 1.1em solid #2196F3;
        border-bottom: 1.1em solid rgb(0 0 0 / 20%);
        border-left: 1.1em solid #2196F3;
        -webkit-transform: translateZ(0);
        -ms-transform: translateZ(0);
        transform: translateZ(0);
        -webkit-animation: load8 1.1s infinite linear;
        animation: load8 1.1s infinite linear;
    }
    @-webkit-keyframes load8 {
      0% {
        -webkit-transform: rotate(0deg);
        transform: rotate(0deg);
      }
      100% {
        -webkit-transform: rotate(360deg);
        transform: rotate(360deg);
      }
    }
    @keyframes  load8 {
      0% {
        -webkit-transform: rotate(0deg);
        transform: rotate(0deg);
      }
      100% {
        -webkit-transform: rotate(360deg);
        transform: rotate(360deg);
      }
    }

  </style>
  <div style="background: rgba(0,0,0,0.5); position: fixed; top: 0; left: 0; bottom: 0; right: 0; width: 100%; height: 100%; padding: 50px; z-index: 4000; display: none;" id="spinner">      
        <center>
          <div class="loader">Loading...</div>
          <h2 class="text-white"><strong>Enviando el mensaje...</strong></h2>
          <strong class="text-white">Por favor, espere</strong><br>          
        </center>
    </div>
  <div class="p-3">
    <div class="row">
      <div class="col-md-6">
        <center><img class="imagen-responsive d-none d-md-block mt-4 mb-3" src="<?php echo e(asset('img/guatehoteles.png')); ?>"></center>
      </div>
      <div class="col-md-6">
        <div class="card box-shadow">
          <div class="card-body">
            <center><h4 class="mt-2">Solicitud de reserva para: <br><?php echo e($habitacion->nombre); ?></h4></center>
            <div class="ml-3">
              <h4 class="mt-2 mb-0 pb-0"><?php echo e($hotel->nombre); ?></h4>
              <?php for($e=0;$e<$hotel->estrellas;$e++): ?>
                <i class="material-icons text-warning" style="display: inline-block; font-size: 18px;">star</i>
              <?php endfor; ?>
              <br>
              <div class="text-primary">
                <i class="material-icons"style="font-size: 18px;" >location_on</i> 
                <p id="text-ubicacion" style="display: inline-block;">
                  <?php echo e($hotel->ubicacion->municipio->municipio); ?> -
                  <?php echo e($hotel->ubicacion->departamento->departamento); ?>

                </p>
              </div>
            </div>
            <hr>
            <div id="div-form">
              <form action="#" method="post">
                <?php echo csrf_field(); ?>
                <div class="row">
                  <div class="col-md-6">
                    <h6>Habitación <strong class="text-danger">*</strong></h6>
                    <input type="text" name="habitacion" class="form-control" disabled="disabled" value="<?php echo e($habitacion->nombre); ?>"><br>
                  </div>
                  <div class="col-md-6">
                    <h6>Fecha de entrada <strong class="text-danger">*</strong></h6>
                    <input type="date" name="check_in" class="form-control" disabled="disabled" value="<?php echo e($check_in); ?>"><br>
                  </div>
                  <div class="col-md-6">
                    <h6>Fecha de salida <strong class="text-danger">*</strong></h6>
                    <input type="date" name="check_out" class="form-control" disabled="disabled" value="<?php echo e($check_out); ?>"><br>
                  </div>
                  <div class="col-md-6">
                    <h6>Número de huésped <strong class="text-danger">*</strong></h6>
                    <input type="text" name="habitacion" class="form-control" disabled="disabled" value="<?php echo e($huesped); ?>"><br>
                  </div>
                  <div class="col-md-12"><hr></div>
                  <div class="col-md-6">
                    <h6>Nombre <strong class="text-danger">*</strong></h6>
                    <input type="text" name="nombre" class="form-control" disabled="disabled" value="<?php echo e(Auth::user()->name); ?>"><br>
                  </div>
                  <div class="col-md-6">
                    <h6>Correo electrónico <strong class="text-danger">*</strong></h6>
                    <input type="text" name="email" class="form-control" disabled="disabled" value="<?php echo e(Auth::user()->email); ?>"><br>
                  </div>
                  <div class="col-md-12">
                    <h6>Número de teléfono <strong class="text-danger">*</strong></h6>
                    <input type="text" name="telefono" class="form-control" value="+502" id="telefono"><br>
                  </div>
                  <div class="col-md-12">
                    <h6>Mensaje <strong class="text-danger">*</strong></h6>
                    <textarea class="form-control" name="mensaje" placeholder="Describe tu mensaje" id="mensaje" style="min-height: 150px;"></textarea>
                    <div id="status-mensaje"></div>
                    <br>
                  </div>
                  <div class="col-md-12">                    
                      <?php echo NoCaptcha::display(); ?>

                      <div id="status-r"></div>                 
                  </div>
                  <div class="col-md-12">
                    
                    <div class="text-right">
                      <button type="button" class="btn btn-primary mt-1" onclick="enviar();">Enviar Mensaje</button>
                    </div>
                  </div>
                </div>
              </form>
            </div>
          </div>
        </div>
      </div>
      
    </div>
  </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
  <script type="text/javascript">
    function enviar() {
      var googleResponse = jQuery('#g-recaptcha-response').val();
      var mensaje = $('#mensaje').val();
      var telefono = $('#telefono').val();

      if (mensaje=='') {
        $('#status-mensaje').html(`<p class='text-danger'><strong>El campo mensaje es obligatorio</strong></p>`);
      }else{
        if (!googleResponse) {
          $('#status-r').html(`<p class='text-danger'><strong>El recaptcha es obligatorio</strong></p>`);
        }else{
          
          $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')     
            }
          }); 

          $('#spinner').css({'display':'block'});

          $.ajax({
            url:'<?php echo route('hotel.reserva.enviar',$hotel->id); ?>',       
            type:'post',  
            data:{
              id_habitacion: <?php echo $habitacion->id; ?>,
              check_in:'<?php echo $check_in;?>',
              check_out:'<?php echo $check_out;?>',
              huesped:<?php echo $huesped; ?>,
              telefono:telefono,
              mensaje: mensaje,
              googleResponse:googleResponse
            },   
            success: function (response) {  
              if (response=='OK') {
                $('#div-form').html(`
                  <center>
                    <div class="mt-3">
                      <div class="text-success mb-1">
                        <svg xmlns="http://www.w3.org/2000/svg" width="200" height="200" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-check-circle"><path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"></path><polyline points="22 4 12 14.01 9 11.01"></polyline></svg>
                      </div>
                      <h4 class="text-success"><strong>Mensaje enviado!</strong></h4>
                    </div>
                  </center>
                `);
              }else{
                console.log(response);
              }
              $('#spinner').css({'display':'none'});    
            }
          });
        }
      }
    }
  </script>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/guatehoteles/public_html/resources/views/reserva.blade.php ENDPATH**/ ?>