

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="javascript:void(0);">Inicio</a></li>
    <li class="breadcrumb-item" aria-current="page"><a href="<?php echo e(route('hoteles.index')); ?>">Hoteles</a></li>
    
    <li class="breadcrumb-item active" aria-current="page"><span>Editar</span></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/forms/switches.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/forms/theme-checkbox-radio.css')); ?>">
<style type="text/css">
    #imgPreview{
        width: 100%;
        text-align: center;
    }
    #map{
            height: 500px;
        }
    .img-vista img{
        min-width: 100%;
        max-width: 100%;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="row layout-spacing layout-top-spacing feather-icon">
    <div id="font-icon_feather" class="col-lg-12">
        <div class="statbox widget box box-shadow">
            <div class="widget-content widget-content-area bx-top-6">
                <div class="icon-section">
                    <div class="row">
                        <div class="col-xl-12">
                            
                            <center><h4>Editar Hotel</h4></center>
                            <hr>

                            <form action="<?php echo e(route('hoteles.update',$hotel->id)); ?>" method="post" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <div class="row">
                                    <div class="col-md-6">
                                        <h6>Nombre <strong class="text-danger">*</strong></h6>
                                        <input type="text" name="nombre" class="form-control" placeholder="Escriba el nombre del hotel" required="required" value="<?php echo e($hotel->nombre); ?>"><br>
                                    </div>
                                    <div class="col-md-6">
                                        <h6>Estrellas <strong class="text-danger">*</strong></h6>
                                        <select class="form-control" name="estrellas" required="required">
                                            <option value="">seleccione una opción</option>
                                            <option value="0" <?php if($hotel->estrellas==0): ?> selected="selected" <?php endif; ?>>0 estrellas</option>
                                            <option value="1" <?php if($hotel->estrellas==1): ?> selected="selected" <?php endif; ?>>1 estrella</option>
                                            <option value="2" <?php if($hotel->estrellas==2): ?> selected="selected" <?php endif; ?>>2 estrellas</option>
                                            <option value="3" <?php if($hotel->estrellas==3): ?> selected="selected" <?php endif; ?>>3 estrellas</option>
                                            <option value="4" <?php if($hotel->estrellas==4): ?> selected="selected" <?php endif; ?>>4 estrellas</option>
                                            <option value="5" <?php if($hotel->estrellas==5): ?> selected="selected" <?php endif; ?>>5 estrellas</option>
                                        </select><br>
                                    </div>
                                </div>      

                                <div class="row">
                                    <div class="col-md-6">
                                        <h6>Categoría <strong class="text-danger">*</strong></h6>
                                        <select class="form-control" name="categoria" required="required">
                                            <option value="">seleccione una categoría</option>
                                            <?php $__currentLoopData = $categorias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($key->id); ?>"
                                             <?php if($hotel->id_categoria==$key->id): ?> selected="selected" <?php endif; ?>
                                            ><?php echo e($key->categoria); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select><br>
                                    </div>
                                    <div class="col-md-6">
                                        <h6>Sitio Web </h6>
                                        <input type="text" name="web" maxlength="255" class="form-control" placeholder="Introduzca la dirección del sitio web" value="<?php echo e($hotel->web); ?>"><br>
                                    </div>
                                </div>

                                <br>
                                <div class="row">
                                    <div class="col">
                                        <h6>Horario de entrada al hotel <strong class="text-danger">*</strong> </h6>
                                        <!-- Multiple inputs (addon on the right) -->
                                        <div class="input-group">
                                          <input class="form-control" required="required" type="time" value="<?php echo e($hotel->entrada_desde); ?>" name="entrada_desde">
                                          <input class="form-control" required="required" type="time" value="<?php echo e($hotel->entrada_hasta); ?>" name="entrada_hasta">
                                          <div class="input-group-append">
                                            <span class="input-group-text">
                                              <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-clock"><circle cx="12" cy="12" r="10"></circle><polyline points="12 6 12 12 16 14"></polyline></svg>
                                            </span>
                                          </div>
                                        </div>
                                    </div>
                                </div>
                                <br>

                                <div class="row">
                                    <div class="col-md-6">
                                        <h6>Horario de salida del hotel <strong class="text-danger">*</strong> </h6>
                                        <!-- Multiple inputs (addon on the right) -->
                                        <div class="input-group">
                                          <input class="form-control" required="required" type="time" value="<?php echo e($hotel->salida); ?>" name="salida">
                                          
                                          <div class="input-group-append">
                                            <span class="input-group-text">
                                              <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-clock"><circle cx="12" cy="12" r="10"></circle><polyline points="12 6 12 12 16 14"></polyline></svg>
                                            </span>
                                          </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <h6>Vídeo de presentación (YouTube o Vimeo)</h6>
                                        <input class="form-control" name="video" type="text" placeholder="Ingrese la URL del Vídeo" value="<?php echo e($hotel->video); ?>">
                                    </div>
                                </div>

                                <br>

                                <div class="row">
                                    <div class="col-md-6">
                                        <h6>Descripción corta del hotel</h6>
                                        <textarea name="descripcion_corta" class="form-control" placeholder="Describe tu hotel de manera breve max. 300 caracteres" maxlength="300" style="min-height: 150px !important;"><?php echo e($hotel->descripcion_corta); ?></textarea>
                                    </div>
                                    <div class="col-md-6">
                                        <h6>Edad mínima para realizar el registro de la entrada al hotel <strong class="text-danger">*</strong></h6>

                                        <input type="number" name="edad_checkin" class="form-control" required="required" min="0" placeholder="Ej 18" value="<?php echo e($hotel->edad_minima_registro_entrada); ?>"><br>
                                        <h6>¿Ofreces cunas en el hotel? <strong class="text-danger">*</strong></h6>

                                            <div class="n-chk" style="display: inline-block;">
                                                <label class="new-control new-radio new-radio-text radio-classic-primary">
                                                  <input type="radio" class="new-control-input" name="cunas" value="S" <?php if($hotel->cunas=='S'){echo "checked";} ?> required="required">
                                                  <span class="new-control-indicator"></span><span class="new-radio-content">Si</span>
                                                </label>
                                            </div>
                                            <div class="n-chk" style="display: inline-block;">
                                                <label class="new-control new-radio new-radio-text radio-classic-primary">
                                                  <input type="radio" class="new-control-input" name="cunas" value="N" <?php if($hotel->cunas=='N'){echo "checked";} ?> required="required">
                                                  <span class="new-control-indicator"></span><span class="new-radio-content">No</span>
                                                </label>
                                            </div>
                                    </div>
                                </div>

                                <br>

                                <div class="row img-color-div" id="img-color-null">
                                            <div class="col-md-12">
                                                <p class="mt-2 ml-1" style="display: inline-block;"><strong>Fotos</strong></p>
                                            </div>
                                            <div class="row m-3">
                                                <?php $__currentLoopData = $hotel->imagenes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key2): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="col-md-3" id="div-foto-db-<?php echo e($key2->id); ?>">
                                                        <div class='imgPreview'>
                                                            <img src="<?php echo e(asset($key2->img)); ?>">
                                                        </div>
                                                        <div> 
                                                            <center> 
                                                                <br>
                                                                <button type="button" class="btn btn-outline-danger" onclick="delete_db_foto('<?php echo e($key2->id); ?>');">Eliminar</button>  
                                                            </center>
                                                         </div>
                                                    </div>

                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <div id="imgPreview-" class="col-12"></div>
                                            </div>
                                            <div class="col-md-12">
                                                <br>
                                                <div class="cz-file-drop-area">
                                                  <div class="cz-file-drop-icon czi-cloud-upload"></div>
                                                  <span class="cz-file-drop-message">
                                                   Arrastra y suelta aquí para subir una foto</span>
                                                  <input type="file" 
                                                      accept="image/x-png,image/jpeg" 
                                                      class="cz-file-drop-input input-foto"
                                                      color="" 
                                                      multiple="multiple">
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <div id="img-db"></div>
                                                <div id="img_db_delete"></div>
                                                <div id="img_db_delete_logo"></div>
                                                <hr>
                                            </div>
                                        </div>
                                <br>
                                <div class="row">
                                    <div class="col">
                                        <center>
                                            <a href="javascript:add_fotos()" class="btn btn-outline-primary mb-2">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-plus"><line x1="12" y1="5" x2="12" y2="19"></line><line x1="5" y1="12" x2="19" y2="12"></line></svg>
                                                Añadir otra foto
                                            </a>
                                        </center>
                                    </div>
                                </div>
                                <div class="row">
                                 <div class="col-md-6">
                                         <p class="mt-2 ml-1" style="display: inline-block;"><strong>Logo</strong></p>
                                        <div class="custom-file">
                                          <input class="custom-file-input <?php echo e($errors->has('foto') ?  "is-invalid" : ""); ?>"
                                                 type="file"
                                                 id="file-input"
                                                 name="logo">
                                          <label class="custom-file-label" for="file-input">Subir logo...</label>

                                        </div>
                                        <p style="text-align: justify; font-size: 18px;">
                                            <br>
                                            Sube el logo de tu hotel en formato <strong>.SVG</strong> o <strong>.PNG.</strong> Dimensión recomendada <strong>100x100.</strong> <br>
                                            Max. <strong>100Kb</strong>
                                        </p>
                                    </div>
                                    <?php if($hotel->logo): ?>
              
                                         <div class="col-md-6">
                                            <div class="col-md-3" id="div-logo-db">
                                                <div class='imgPreview'>
                                                    <img src="<?php echo e(asset($hotel->logo)); ?>">
                                                </div>
                                                <div> 
                                                    <center> 
                                                        <br>
                                                        <button type="button" class="btn btn-outline-danger" onclick="delete_db_logo('<?php echo e($hotel->logo); ?>');">Eliminar</button>  
                                                    </center>
                                                 </div>
                                            </div>
                                            </div>
                                    <?php endif; ?>
                                        </div>
                                    <br>
                                <br>
                                <div class="row">
                                    <div class="col-12">
                                        <center><h4><strong>Servicios</strong></h4></center>
                                    </div>

                                        <?php $otros_servicios = array(); ?>
                                        <?php $__currentLoopData = $servicios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if(is_null($key->id_servicio) &&  $key->subservicios->count() >0 ): ?>
                                                <div class="col-md-12">
                                                    <br>
                                                    <img style="display: inline-block
                                                    width: 40px !important; position: absolute;" 
                                                    class="material-icons" 
                                                    src="<?php echo e(asset($key->img)); ?>" 
                                                    data-toggle="tooltip" data-placement="top" 
                                                    title="<?php echo e($key->servicio); ?>">

                                                    <h5 style="display: inline-block;" class="ml-5 mt-2">
                                                        <?php echo e($key->servicio); ?>

                                                    </h5>
                                                    <br><br>

                                                    <div class="mt-1 ml-4 mb-1 row">
                                                        
                                                        <?php $__currentLoopData = $key->subservicios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <div class="col-md-6">
                                                                <div class="mt-1"></div>
                                                                <label class="switch s-outline s-primary mr-2" style="display: inline-block; margin-bottom: 0px">

                                                                <input type="checkbox" name="servicios[]" value="<?php echo e($key->id); ?>"

                                                                <?php 
                                                                    if (in_array($key->id, $servicios_hotel)) {
                                                                        echo "checked='checked'";
                                                                    }
                                                                ?>

                                                                >

                                                                <span class="slider round"></span>
                                                                </label>

                                                                <h5 style="display: inline-block; padding: 0px;"><?php echo e($key->servicio); ?>

                                                                </h5> 
                                                            </div>

                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </div>
                                                    <hr>
                                                </div>
                                            <?php else: ?>
                                                <?php if(is_null($key->id_servicio)): ?>
                                                    <?php 
                                                        array_push($otros_servicios, $key);
                                                    ?>
                                                <?php endif; ?>
                                            <?php endif; ?>                                            
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                            <div class="col-md-12">
                                            <br>
                                            <img style="display: inline-block
                                                width: 40px !important; position: absolute;" 
                                                class="material-icons" 
                                                src="<?php echo e(asset('img/servicios/check.svg')); ?>" 
                                                data-toggle="tooltip" data-placement="top" 
                                                title="Otros Servicios">

                                            <h5 style="display: inline-block;" class="ml-4 mt-2">
                                                Otros Servicios
                                            </h5>

                                            <div class="mt-1 ml-3 mb-1 row">
                                                <?php $__currentLoopData = $otros_servicios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="col-md-6">
                                                        
                                                        <div class="mt-1"></div>
                                                        <label class="switch s-outline s-primary mr-2" style="display: inline-block; margin-bottom: 0px">

                                                        <input type="checkbox" name="servicios[]" value="<?php echo e($key->id); ?>"

                                                        <?php 
                                                            if (in_array($key->id, $servicios_hotel)) {
                                                                echo "checked='checked'";
                                                            }
                                                        ?>

                                                        >

                                                        <span class="slider round"></span>
                                                        </label>
                                                        
                                                        <h5 style="display: inline-block; padding: 0px;"><?php echo e($key->servicio); ?>

                                                        </h5> 
                                                    <br>        
                                                        
                                                    </div>                             
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                            <br><br>
                                        </div>                                 
                                    
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <h6>Teléfono <strong class="text-danger">*</strong></h6>
                                        <input type="number" name="telefono[]" class="form-control telefono" placeholder="Introduzca su número de teléfono" required="" value="<?php echo e($hotel->contactos[0]->telefono); ?>"><br>
                                    </div>

                                    <div class="col-md-6">
                                        <h6>Correo electrónico <strong class="text-danger">*</strong></h6>
                                        <input type="email" name="email[]" class="form-control email" placeholder="Introduzca su correo electrónico" required="" value="<?php echo e($hotel->contactos[0]->email); ?>"><br>
                                    </div>

                                    <!--<input type="hidden" name="db_id[]" value="<?php echo e($hotel->contactos[0]->id); ?>">-->
                                </div>
                                <?php $i=0; ?>
                                <?php $__currentLoopData = $hotel->contactos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if ($i==0) {
                                        $i++;
                                        continue;
                                    } ?>

                                    <div class="row" id="contacto-<?php echo e($i - 1); ?>">
                                        <div class="col-md-5">
                                            <h6>Teléfono </h6>
                                            <input type="number" name="telefono[]" class="form-control telefono form-contacto-<?php echo e($i - 1); ?>" placeholder="Introduzca su número de teléfono" value="<?php echo e($key->telefono); ?>"><br>
                                        </div>

                                        <div class="col-md-5">
                                            <h6>Correo electrónico </h6>
                                            <input type="email" name="email[]" class="form-control email form-contacto-<?php echo e($i - 1); ?>" placeholder="Introduzca su correo electrónico" value="<?php echo e($key->email); ?>"><br>
                                        </div>

                                        <input type="hidden" name="db_id[]" value="<?php echo e($key->id); ?>">

                                        <input type="hidden" name="db_contacto_email[]" value="<?php echo e($key->email); ?>" class="contacto-db-<?php echo e($key->id); ?>">

                                        <input type="hidden" name="db_contacto_telefono[]" value="<?php echo e($key->telefono); ?>" class="contacto-db-<?php echo e($key->id); ?>">

                                        <div class='col-md-2'>
                                            <center>
                                                <br>
                                                <a href="javascript:delete_contacto(<?php echo e($i - 1); ?>)" class="btn btn-outline-danger mt-2">
                                                   <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-x-circle table-cancel"><circle cx="12" cy="12" r="10"></circle><line x1="15" y1="9" x2="9" y2="15"></line><line x1="9" y1="9" x2="15" y2="15"></line></svg>
                                                   Eliminar
                                                </a><br>
                                            </center>
                                        </div>

                                    </div>  
                                    <?php $i++; ?>      
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php $id_contacto = $i; ?>
                                <div id="add_contacto"></div>

                                <div class="row">
                                    <div class="col">
                                        <center>
                                            <a href="javascript:add_contacto()" class="btn btn-outline-primary mb-2">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-plus"><line x1="12" y1="5" x2="12" y2="19"></line><line x1="5" y1="12" x2="19" y2="12"></line></svg>
                                                Añadir más contactos
                                            </a>
                                        </center>
                                    </div>
                                </div>

                                <br>

                                <div class="row">
                                    <div class="col-md-6">
                                        <h6>Departamento <strong class="text-danger">*</strong></h6>
                                        <select class="form-control" name="departamento" id="departamento">
                                            <option>Selecciona una opción</option>
                                            <?php $__currentLoopData = $departamentos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($key->id); ?>"

                                                <?php if($hotel->ubicacion->id_departamento == $key->id) echo "selected"; ?>

                                            ><?php echo e($key->departamento); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="col-md-6">
                                        <h6>Municipio <strong class="text-danger">*</strong></h6>
                                        <select class="form-control" name="municipio" id="municipio">
                                            <option value="">Seleccione una opción</option>
                                            <?php $__currentLoopData = $hotel->ubicacion->departamento->municipios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($key->id); ?>"    
                                                <?php if($hotel->ubicacion->id_municipio == $key->id) echo "selected"; ?>
                                                ><?php echo e($key->municipio); ?></option>   
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                                <br>
                                   <div class="row">
                                        <div class="col-md-6">
                                        <h6>Dirección</h6>
                                        <textarea name="direccion" class="form-control" placeholder="Ingresa la dirección max 300 caracteres" maxlength="300" style="min-height: 150px !important;"><?php echo e($hotel->ubicacion->direccion); ?></textarea>
                                    </div>
                                </div>
                                <br>
                                <div class="row">
                                    <div class="col-md-12">
                                        <h6>Geolocalización </h6>
                                        <input type="hidden" name="longitud" id="longitud" value="<?php echo e($hotel->ubicacion->longitud); ?>">
                                        <input type="hidden" name="latitud" id="latitud" value="<?php echo e($hotel->ubicacion->latitud); ?>">
                                        <p>Arrastre el marcado para establecer la dirección exacta de su negocio o empresa. Esto ayudará a que los usuarios encuentren más fácil tu ubicación y poder canjear los cupones</p>
                                        <div id="map"></div>
                                    </div>
                                </div>

                                <br>
                                <br>
                                <div class="row">
                                    <div class="col-12">
                                        <center><h4><strong>Tarjetas que acepta el hotel</strong></h4></center>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="p-5 row">
                                            <?php $__currentLoopData = $tarjetas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="col-md-6">
                                                    <label class="switch s-outline s-primary mr-2" style="display: inline-block; margin-bottom: 0px">
                                                        <input type="checkbox" name="tarjetas[]" value="<?php echo e($key->id); ?>"
                                                        <?php 
                                                        if (in_array($key->id, $tarjetas_hotel)) {
                                                            echo "checked='checked'";
                                                        }
                                                        ?>
                                                    >
                                                        <span class="slider round"></span>
                                                    </label>
                                                    <h5 style="display: inline-block;padding: 0px;"><img src="<?php echo e(asset($key->img)); ?>"></h5>
                                                    <br><br>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>                                        
                                    </div>
                                    <div class="col-md-6">
                                        <br>
                                        <center>
                                            <svg xmlns="http://www.w3.org/2000/svg" width="200px" height="200px" viewBox="0 0 24 24" fill="none" stroke="#0e1726" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-credit-card"><rect x="1" y="4" width="22" height="16" rx="2" ry="2"></rect><line x1="1" y1="10" x2="23" y2="10"></line></svg>
                                        </center>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">                                        
                                        <h6>¿Aceptas mascotas? <strong class="text-danger">*</strong></h6>
                                        <select class="form-control" name="mascota" id="mascota" required="required">
                                            <option value="">Seleccione una opción</option>
                                            <option value="S" <?php if($hotel->mascotas=='S'): ?> selected="selected" <?php endif; ?> >Si</option>
                                            <option value="N" <?php if($hotel->mascotas=='N'): ?> selected="selected" <?php endif; ?> >No</option>
                                        </select>
                                    </div>
                                    <div class="col-md-6">                                        
                                        <h6>¿Las mascotas posee un costo adicional? <strong class="text-danger">*</strong></h6>
                                        <select class="form-control" name="mascota_costo"
                                        <?php if($hotel->mascotas=='N'): ?> disabled="disabled" <?php endif; ?>
                                          id="mascota_costo" required="required">
                                            <option value="">Seleccione una opción</option>
                                            <option value="S" <?php if($hotel->mascotas_costo_adicional=='S'): ?> selected="selected" <?php endif; ?>>Si</option>
                                            <option value="N" <?php if($hotel->mascotas_costo_adicional=='n'): ?> selected="selected" <?php endif; ?>>No</option>
                                        </select>
                                    </div>
                                </div>
                                <br>
                                <div class="row">
                                    <div class="col-md-6">
                                        <h6>¿Tienes una edad mínima para el check-in ?  <strong class="text-danger">*</strong> </h6>
                                        <select class="form-control" name="edad" id="edad" required="required">

                                            <?php 
                                                if(is_null($hotel->edad_minima)){
                                                    $ON = 'selected="selected"';
                                                    $OS = '';
                                                }else{
                                                    $OS = 'selected="selected"';
                                                    $ON = '';
                                                }
                                            ?>

                                            <option value="">Seleccione una opción</option>
                                            <option value="S" <?php echo e($OS); ?> >Si</option>
                                            <option value="N" <?php echo e($ON); ?> >No</option>
                                        </select>
                                    </div>
                                    <div class="col-md-6">
                                        <h6>¿Seleccione una edad mínima <strong class="text-danger">*</strong> </h6>
                                        <select class="form-control" name="edad_minima" 
                                        <?php if(is_null($hotel->edad_minima)): ?> disabled="disabled" <?php endif; ?>
                                         id="edad_minima" required="required">
                                            <option value=""
                                            <?php if(is_null($hotel->edad_minima)): ?> selected='selected' <?php endif; ?>
                                            >Seleccione una edad mínima</option>
                                            <option value="0" 
                                            <?php if($hotel->edad_minima==0): ?> 
                                                    selected='selected' 
                                                    <?php endif; ?>>0 años</option>
                                            <option value="1" 
                                            <?php if($hotel->edad_minima==1): ?> 
                                                    selected='selected' 
                                                    <?php endif; ?>>1 año</option>
                                            <option value="2" 
                                            <?php if($hotel->edad_minima==2): ?> 
                                                    selected='selected' 
                                                    <?php endif; ?>>2 años</option>
                                            <option value="3" 
                                            <?php if($hotel->edad_minima==3): ?> 
                                                    selected='selected' 
                                                    <?php endif; ?>>3 años</option>
                                            <option value="4" 
                                            <?php if($hotel->edad_minima==4): ?> 
                                                    selected='selected' 
                                                    <?php endif; ?>>4 años</option>
                                            <option value="5" 
                                            <?php if($hotel->edad_minima==5): ?> 
                                                    selected='selected' 
                                                    <?php endif; ?>>5 años</option>
                                            <option value="6" 
                                            <?php if($hotel->edad_minima==6): ?> 
                                                    selected='selected' 
                                                    <?php endif; ?>>6 años</option>
                                            <option value="7" 
                                            <?php if($hotel->edad_minima==7): ?> 
                                                    selected='selected' 
                                                    <?php endif; ?>>7 años</option>
                                            <option value="8" 
                                            <?php if($hotel->edad_minima==8): ?> 
                                                    selected='selected' 
                                                    <?php endif; ?>>8 años</option>
                                            <option value="9" 
                                            <?php if($hotel->edad_minima==9): ?> 
                                                    selected='selected' 
                                                    <?php endif; ?>>9 años</option>
                                            <option value="10"
                                             <?php if($hotel->edad_minima==10): ?>
                                                     selected='selected'
                                                      <?php endif; ?>>10 años</option>
                                            <option value="11"
                                             <?php if($hotel->edad_minima==11): ?>
                                                     selected='selected'
                                                      <?php endif; ?>>11 años</option>
                                            <option value="12"
                                             <?php if($hotel->edad_minima==12): ?>
                                                     selected='selected'
                                                      <?php endif; ?>>12 años</option>
                                            <option value="13"
                                             <?php if($hotel->edad_minima==13): ?>
                                                     selected='selected'
                                                      <?php endif; ?>>13 años</option>
                                            <option value="14"
                                             <?php if($hotel->edad_minima==14): ?>
                                                     selected='selected'
                                                      <?php endif; ?>>14 años</option>
                                            <option value="15"
                                             <?php if($hotel->edad_minima==15): ?>
                                                     selected='selected'
                                                      <?php endif; ?>>15 años</option>
                                            <option value="16"
                                             <?php if($hotel->edad_minima==16): ?>
                                                     selected='selected'
                                                      <?php endif; ?>>16 años</option>
                                            <option value="17"
                                             <?php if($hotel->edad_minima==17): ?>
                                                     selected='selected'
                                                      <?php endif; ?>>17 años</option>

                                            <option value="18"
                                             <?php if($hotel->edad_minima==18): ?>
                                                     selected='selected'
                                                      <?php endif; ?>>18 años</option>
                                        </select>
                                    </div>
                                </div>
                                <br>
                                <div class="row">
                                    <?php if(Auth::user()->rol_id==1): ?>
                                        <div class="col-md-6">
                                            <h6>¿El hotel es de su propiedad? <strong class="text-danger">*</strong></h6>
                                                <div class="n-chk">
                                                    <label class="new-control new-radio new-radio-text radio-classic-primary">
                                                      <input type="radio" class="new-control-input" name="reclamar" value="N" <?php if($hotel->reclamar == 'N'): ?> checked <?php endif; ?>>
                                                      <span class="new-control-indicator"></span><span class="new-radio-content">Si</span>
                                                    </label>
                                                </div>
                                                <div class="n-chk">
                                                    <label class="new-control new-radio new-radio-text radio-classic-primary">
                                                      <input type="radio" class="new-control-input" name="reclamar" value="S" <?php if($hotel->reclamar == 'S'): ?> checked <?php endif; ?>>
                                                      <span class="new-control-indicator"></span><span class="new-radio-content">No</span>
                                                    </label>
                                                </div>
                                        </div>
                                    <?php endif; ?>
                                    <div class="col-md-6">
                                        <h6>Recomendado  por :</h6>
                                        <?php if(Auth::user()->rol_id!=1): ?>
                                        <h6>Requiere aprobación del administrador</h6><br>
                                        <?php endif; ?>
                                        <?php $__currentLoopData = $empresas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <label class="switch s-outline s-primary mr-2" style="display: inline-block; margin-bottom: 0px">
                                                    <input type="checkbox" name="empresa[]" value="<?php echo e($key->id); ?>"

                                                    <?php 
                                                        if (in_array($key->id, $recomendaciones_hotel)) {
                                                            echo "checked='checked'";
                                                        }
                                                    ?>
                                                    >
                                                    <span class="slider round"></span>
                                                </label>
                                                <h5 style="display: inline-block; padding: 0px;"><?php echo e($key->empresa); ?></h5><br><br>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                                
                                <br>

                                <div class="row">
                                    <div class="col">
                                        <h6>Información importante</h6>
                                        <textarea class="form-control" name="informacion_importante" placeholder="Describa una información importante que los huéspedes tenga que saber " style="min-height: 150px;"><?php echo e($hotel->informacion_importante); ?></textarea>
                                    </div>
                                </div>
                                <br>
                                <div class="row">
                                    <div class="col">
                                        <h6>Aviso importante</h6>
                                        <textarea class="form-control" name="aviso_importante" placeholder="Describa un aviso importante para los huéspedes" style="min-height: 150px;"><?php echo e($hotel->aviso_importante); ?></textarea>
                                    </div>
                                </div>
                                <br>
                                <div class="row">
                                    <div class="col">
                                        <h6>Descripción</h6>
                                        <textarea class="form-control" placeholder="Describa la respuesta de la pregunta" name="descripcion" id="respuesta"><?php echo e($hotel->descripcion); ?></textarea><br>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col">
                                        <button type="submit" class="btn btn-primary float-right">Actualizar</button>
                                    </div>
                                </div>
                                <input type="hidden" name="total" id="total" value="<?php 
                                    echo $hotel->contactos->count();
                                 ?>">
                                <?php $i=0; ?>
                            </form>                                         
                        </div>
                    </div>
                </div>         
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script type="text/javascript" src="<?php echo e(asset('js/ckeditor/ckeditor.js')); ?>"></script>
    <script type="text/javascript">
        CKEDITOR.replace('respuesta');
    </script>
       <script type="text/javascript">
    var departamentos = [
      <?php 
        foreach ($departamentos as $key) {
          echo "
            {
              id:".$key->id.',
              municipios:[              
            ';

            foreach ($key->municipios as $key2) {
              echo "
                {
                  id:".$key2->id.",
                  municipio: '".$key2->municipio."'
                },
              ";
            }

            echo "]},";
        }
      ?>
    ];

    $('#departamento').change(function(){

      var value = $(this).val();

      if (value=='') {

        var option = '<option value="">Selecciona una opción</option>';
        $('#municipio').html(option);

      }else{
        var option = '<option value="">Selecciona una opción</option>';

        var municipios = departamentos[value - 1].municipios;

        municipios.forEach(function(element){
          option = option + '<option value="'+element.id+'">'+element.municipio+'</option>';
        });

        $('#municipio').html(option);
      }
    });    

    var total = <?php echo $hotel->contactos->count(); ?>;
    var id_contacto = <?php echo $id_contacto; ?>;

    function add_contacto(){
        
        $('#add_contacto').before(`

            <div class="row" id="contacto-${id_contacto}">
                <div class="col-md-5">
                    <h6>Teléfono </h6>
                    <input type="number" name="telefono[]" class="form-control telefono form-contacto-${id_contacto}" placeholder="Introduzca su número de teléfono"><br>
                </div>

                <div class="col-md-5">
                    <h6>Correo electrónico </h6>
                    <input type="email" name="email[]" class="form-control email form-contacto-${id_contacto}" placeholder="Introduzca su correo electrónico"><br>
                </div>

                <div class='col-md-2'>
                    <center>
                        <br>
                        <a href="javascript:delete_contacto(${id_contacto})" class="btn btn-outline-danger mt-2">
                           <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-x-circle table-cancel"><circle cx="12" cy="12" r="10"></circle><line x1="15" y1="9" x2="9" y2="15"></line><line x1="9" y1="9" x2="15" y2="15"></line></svg>
                           Eliminar
                        </a><br>
                    </center>
                </div>

            </div>
        `);
        total = total + 1;
        id_contacto = id_contacto + 1;
        $('#total').val(total);
    }

    function delete_contacto(id,id_db=null){

        if (id_db!=null) {
            $('.contacto-db-'+id).val('');
        }

        $('.form-contacto-'+id).val('');

        $('#contacto-'+id).css({'display':'none'});
    }

  </script>

    <?php $api_key = env('KEY_GOOGLE_MAP'); ?>
    <script src="https://maps.googleapis.com/maps/api/js?key=<?php echo $api_key; ?>&callback=initMap" 
        async defer></script>

    <script type="text/javascript">
        
    var marker;          //variable del marcador
    var coords = {};    //coordenadas obtenidas con la geolocalización

    //Funcion principal
    initMap = function () 
    {
        //usamos la API para geolocalizar el usuario
        navigator.geolocation.getCurrentPosition(
            function (position){
            coords =  {
                lng:<?php echo $hotel->ubicacion->longitud; ?>,
                lat:<?php echo $hotel->ubicacion->latitud; ?>
            };
        setMapa(coords);  //pasamos las coordenadas al metodo para crear el mapa       
        },function(error){
            coords =  {
                lng:-90.2307587,
                lat:15.7834711
            };
            setMapa(coords);
        });
    }

    function setMapa (coords)
    {   
          //Se crea una nueva instancia del objeto mapa
          document.getElementById('longitud').value =coords.lng;
          document.getElementById('latitud').value = coords.lat;
          var map = new google.maps.Map(document.getElementById('map'),
          {
            zoom: 16,
            center:new google.maps.LatLng(coords.lat,coords.lng),

          });

          //Creamos el marcador en el mapa con sus propiedades
          //para nuestro obetivo tenemos que poner el atributo draggable en true
          //position pondremos las mismas coordenas que obtuvimos en la geolocalización
          marker = new google.maps.Marker({
            map: map,
            draggable: true,
            animation: google.maps.Animation.DROP,
            position: new google.maps.LatLng(coords.lat,coords.lng),

          });
          //agregamos un evento al marcador junto con la funcion callback al igual que el evento dragend que indica 
          //cuando el usuario a soltado el marcador
          marker.addListener('click', toggleBounce);
          
          marker.addListener( 'dragend', function (event)
          {
            //escribimos las coordenadas de la posicion actual del marcador dentro del input #coords
            //document.getElementById("coords").value = this.getPosition().lat()+","+ this.getPosition().lng();
            document.getElementById('longitud').value = this.getPosition().lng();
            document.getElementById('latitud').value = this.getPosition().lat();
          });
    }
    function toggleBounce() {
      if (marker.getAnimation() !== null) {
        marker.setAnimation(null);
      } else {
        marker.setAnimation(google.maps.Animation.BOUNCE);
      }
    }
   </script>

<script type="text/javascript">
    var df_route_cargar = '<?php echo route('hoteles.fotos'); ?>';
    var route_eliminar = '<?php echo route("hoteles.fotos.delete"); ?>';
</script>

<script type="text/javascript" src="<?php echo e(asset('js/fotos.js')); ?>"></script>

<script type="text/javascript">
    $('#edad').change(function(){
        var value = $(this).val();

        if (value=='S') {
            $('#edad_minima').prop('disabled',false);
        }else{
            $('#edad_minima').prop('disabled',true);
        }
    });

    $('#mascota').change(function(){
        var value = $(this).val();

        if (value=='S') {
            $('#mascota_costo').prop('disabled',false);
        }else{
            $('#mascota_costo').prop('disabled',true);
        }
    });
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp74\htdocs\guatehoteles\resources\views/admin/hoteles/edit.blade.php ENDPATH**/ ?>