

<?php $__env->startSection('breadcrumb'); ?>
	<li class="breadcrumb-item"><a href="javascript:void(0);">Inicio</a></li>
    <li class="breadcrumb-item"><a href="<?php echo e(route('hoteles.index')); ?>">Hotel</a></li>
    <li class="breadcrumb-item active" aria-current="page"><span>Habitaciones</span></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/widgets/modules-widgets.css')); ?>">    
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/datatables.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/dt-global_style.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
	<br><br>

				<div class="row analytics">
                    <div class="col">
                        <div class="row widget-statistic">
                            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                                <div class="widget widget-one_hybrid widget-followers">
                                    <div class="widget-heading">
                                        <div class="w-icon">
                                            <svg xmlns="http://www.w3.org/2000/svg" height="24" viewBox="0 0 24 24" width="24"><path d="M0 0h24v24H0V0z" fill="none"/><path d="M7 13c1.65 0 3-1.35 3-3S8.65 7 7 7s-3 1.35-3 3 1.35 3 3 3zm12-6h-8v7H3V7H1v10h22v-6c0-2.21-1.79-4-4-4z"/></svg>
                                        </div>
                                        <p class="w-value"><?php echo e($total); ?></p>
                                        <h5 class="">Habitaciones Registradas</h5>
                                    </div>
                                    <div class="widget-content">    
                                        <div class="w-chart">
                                            <div id="hybrid_followers"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>  

                            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                                <div class="widget widget-one_hybrid widget-engagement">
                                    <div class="widget-heading">
                                        <div class="w-icon">
                                            <svg xmlns="http://www.w3.org/2000/svg" height="24" viewBox="0 0 24 24" width="24"><path d="M0 0h24v24H0V0z" fill="none"/><path d="M7 13c1.65 0 3-1.35 3-3S8.65 7 7 7s-3 1.35-3 3 1.35 3 3 3zm12-6h-8v7H3V7H1v10h22v-6c0-2.21-1.79-4-4-4z"/></svg>
                                        </div>
                                        <p class="w-value"><?php echo e($count); ?></p>
                                        <h5 class="">Habitaciones Publicadas</h5>
                                    </div>
                                    <div class="widget-content">    
                                        <div class="w-chart">
                                            <div id="hybrid_followers3"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                                <form action="<?php echo e(route('habitaciones.hotel',$id)); ?>" method="post" id="form-publicar">
                                    <?php echo csrf_field(); ?>
                                    <center><h6>Hotel Publicado <strong class="text-danger">*</strong></h6></center>
                                    <select class="form-control" name="publicar" id="publicar"
                                        <?php if($count==0): ?> disabled="disabled"  <?php endif; ?>
                                    >
                                        <option value="S" <?php if($hotel->publicado=='S'): ?> selected="selected"  <?php endif; ?>>Si</option>
                                        <option value="N" <?php if($hotel->publicado=='N'): ?> selected="selected"  <?php endif; ?>>No</option>
                                        
                                    </select>

                                    <center>
                                        <?php if($count==0): ?>
                                            <br>
                                            <svg xmlns="http://www.w3.org/2000/svg" width="150" height="150" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-info"><circle cx="12" cy="12" r="10"></circle><line x1="12" y1="16" x2="12" y2="12"></line><line x1="12" y1="8" x2="12.01" y2="8"></line></svg>

                                            <p>Para poder publicar un hotel en la plataforma, debes de tener una habitación publicada</p>
                                        <?php else: ?>
                                            <?php if($hotel->publicado=='N'): ?>
                                                <br>
                                                <svg xmlns="http://www.w3.org/2000/svg" width="150" height="150" viewBox="0 0 24 24" fill="none" stroke="#f0ad4e" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-alert-triangle"><path d="M10.29 3.86L1.82 18a2 2 0 0 0 1.71 3h16.94a2 2 0 0 0 1.71-3L13.71 3.86a2 2 0 0 0-3.42 0z"></path><line x1="12" y1="9" x2="12" y2="13"></line><line x1="12" y1="17" x2="12.01" y2="17"></line></svg>
                                                <p class="text-warning">
                                                    <strong>Su hotel no esta publicado en la plataforma, si deseas publicarlo, cambia el estado que esta arriba de este mensaje</strong>
                                                </p>
                                            <?php else: ?>
                                                <br>
                                                <svg xmlns="http://www.w3.org/2000/svg" width="150" height="150" viewBox="0 0 24 24" fill="none" stroke="#5cb85c" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-check-circle"><path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"></path><polyline points="22 4 12 14.01 9 11.01"></polyline></svg>
                                                <p class="text-success">
                                                    <strong>Su hotel está publicado en la plataforma</strong>
                                                </p>
                                            <?php endif; ?>

                                        <?php endif; ?>
                                    </center>

                                </form>
                            </div>
                        </div>
                    </div>
                </div>  

                <div class="row layout-spacing layout-top-spacing feather-icon">
                    <div id="font-icon_feather" class="col-lg-12">
                        <div class="statbox widget box box-shadow">
                            <div class="widget-content widget-content-area bx-top-6">
                                <div class="icon-section">
                                    <div class="row">
                                        <div class="col-xl-12">
                                            <div class="row">
                                                <div class="col">
                                                    <h4>Habitaciones</h4>
                                                </div>
                                                <div class="col">
                                                    <a href="<?php echo e(route('habitaciones.create',$id)); ?>" class="btn btn-primary mb-2 float-right">Registrar</a>
                                                </div>
                                            </div>
                                            
                                           
                                            <div class="table-responsive mb-4 mt-4">
                                                <table id="zero-config" class="table table-hover" style="width:100%; text-align: center;">
                                                    <thead>
                                                        <tr>
                                                            <th><?php echo e($i++); ?></th>
                                                            <th>Nombre</th>
                                                            <th>Precio en Q</th>
                                                            <th>Precio en USD</th>
                                                            <th>Publicado</th>
                                                            <th class="no-content"></th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                       <?php $__currentLoopData = $habitaciones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <tr>
                                                            <td style="font-size: 20px;">1</td>
                                                            <td style="font-size: 20px;"><?php echo e($key->nombre); ?></td>
                                                            <td style="font-size: 20px;"><?php echo e($key->precios[1]->precio); ?> Q</td>
                                                            <td style="font-size: 20px;"><?php echo e($key->precios[0]->precio); ?> $</td>
                                                            <td>
                                                                <?php if($key->publicado=='S'): ?>

                                                                <span class="badge badge-success"> Si
                                                                </span>

                                                                <?php else: ?>
                                                                    <span class="badge badge-danger"> No
                                                                </span>
                                                                <?php endif; ?>
                                                            </td>
                                                            <td>
                                                                <a href="<?php echo e(route('habitaciones.edit',$key->id)); ?>" 
                                                                    class="bs-tooltip" 
                                                                    data-toggle="tooltip" data-placement="bottom"
                                                                     title="Editar">
                                                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-edit"><path d="M11 4H4a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2v-7"></path><path d="M18.5 2.5a2.121 2.121 0 0 1 3 3L12 15l-4 1 1-4 9.5-9.5z"></path></svg>
                                                                    </a>
                                                                    <a href="javascript:eliminar('<?php echo e(route('habitaciones.delete',$key->id)); ?>','<?php echo e($key->nombre); ?>')"
                                                                        class="bs-tooltip" 
                                                                        data-toggle="tooltip mr-5" data-placement="bottom"
                                                                        title="Eliminar"

                                                                    >
                                                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-x-circle table-cancel"><circle cx="12" cy="12" r="10"></circle><line x1="15" y1="9" x2="9" y2="15"></line><line x1="9" y1="9" x2="15" y2="15"></line></svg>
                                                                    </a>
                                                            </td>
                                                        </tr>
                                                       <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </tbody>
                                                     <tfoot>
                                                        <tr>
                                                            <th>  </th>
                                                            <th>  </th>
                                                            <th>  </th>
                                                            <th>  </th>
                                                            <th>  </th>
                                                            <th>  </th>
                                                        </tr>
                                                    </tfoot>
                                                </table>
                                            </div>                           
                                        </div>
                                    </div>
                                </div>         
                            </div>
                        </div>
                    </div>
                </div>

                <form id="destroy-form" action="#" method="POST" style="display: none;">
                    <?php echo csrf_field(); ?>
                    <input name="_method" type="hidden" value="DELETE">
                </form>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
	<script src="<?php echo e(asset('js/widgets/modules-widgets.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('js/datatables.js')); ?>"></script>

    <script type="text/javascript" src="<?php echo e(asset('js/table-data.js')); ?>"></script>

    <script type="text/javascript">
        table_data('#zero-config');

        $('#publicar').change(function(){
            $('#form-publicar').submit();
        });

        function eliminar (link,name){
            swal({   
                title: "¿Estás seguro?",
                text: "¿Deseas eliminar la habitación: "+name+"  ?",
                type: "warning",
                showCancelButton: true,
                confirmButtonColor: "#DD6B55",
                confirmButtonText: "Si, eliminar!",
                cancelButtonText: "No, cancelar!",
                closeOnConfirm: false,
                closeOnCancel: false 
            }, function(isConfirm){
                if (isConfirm) {
                    $('#destroy-form').attr('action',link);
                    $('#destroy-form').submit();
                } else {
                    swal("Cancelado", "Tu habitación "+name+" no fue eliminada )", "error");
                }
            });
        }
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp74\htdocs\guatehoteles\resources\views/admin/hoteles/habitaciones/index.blade.php ENDPATH**/ ?>