<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

#Route::get('import','HotelesController@import');

Route::get('/logout',function(){
    return redirect('login');
});

Route::get('auth/{provider}', 'Auth\SocialAuthController@redirectToProvider')->name('social.auth');
Route::get('auth/{provider}/callback', 'Auth\SocialAuthController@handleProviderCallback');


Route::get('/','PortalController@index')->name('inicio');
Route::get('/hoteles','PortalController@hotel')->name('inicio');

Route::get('/hotel/{url}','PortalController@hotel_single')->name('hotel.single');

Route::get('/hotel/reclamar/{id}','ReclamarHotelesController@index')->name('hotel.reclamar');
Route::post('/hotel/reclamar/{id}','ReclamarHotelesController@reclamar')->name('hotel.reclamar')->middleware('auth');

Route::post('/hotel/codigo/reclamar/','ReclamarHotelesController@enviar_codigo')->name('hotel.codigo')->middleware('auth');

Route::post('/hotel/codigo/validar','ReclamarHotelesController@validar_codigo')->name('hotel.validar')->middleware('auth');

Route::get('/hotel/mensaje/{id}','MensajesController@index')->name('hotel.mensaje')->middleware('auth');
Route::post('/hotel/mensaje/{id}','MensajesController@enviar')->name('hotel.mensaje.enviar')->middleware('auth');


Route::get('/hotel/reserva/{id}','MensajesController@reserva')->name('hotel.reserva')->middleware('auth');
Route::post('/hotel/reserva/{id}','MensajesController@reserva_enviar')->name('hotel.reserva.enviar')->middleware('auth');

Route::post('/comentario','PortalController@comentario')->name('comentario.add');
Route::post('/comentario/update','PortalController@comentario_update')->name('comentario.update');

Route::post('/hotel/{url}/habitacion/{id}','PortalController@habitacion_single')->name('habitacion.single');

Route::get('/quienes-somos','PortalController@quienes_somos')->name('portal.quienes-somos');
Route::get('/terminos-de-uso','PortalController@terminos')->name('portal.terminos');
Route::get('/preguntas-frecuentes','PortalController@preguntas')->name('portal.preguntas');
Route::get('/contacto','PortalController@contacto')->name('portal.contacto');
Route::post('/contacto','PortalController@contacto_enviar')->name('portal.contacto');
Route::get('/divisa/{id}','PortalController@cambiar_divisa')->name('moneda');

Route::get('/cuenta/favoritos','FavoritosController@index')->name('favoritos.index')->middleware('auth');
Route::get('/favoritos/{id}','FavoritosController@favoritos')->name('favoritos.favoritos')->middleware('auth');

Auth::routes();

Route::get('/home', 'HomeController@index')->name('home');

	Route::middleware(['auth'])->group(function(){

		Route::get('/cuenta','CuentasController@cuenta')->name('user.cuenta');
		Route::post('/cuenta','CuentasController@cuenta_update')->name('user.cuenta.update');

		Route::get('cuenta/clave','CuentasController@clave')->name('user.clave');
		Route::post('cuenta/clave','CuentasController@clave_update')->name('user.clave.update');
		//Hoteles

		Route::get('/admin/hoteles','HotelesController@index')->name('hoteles.index');
		Route::get('/admin/hoteles/reclamar','HotelesController@hoteles_reclamar')->name('hoteles.reclamar');
		Route::get('/admin/mis-hoteles','HotelesController@mis_hoteles')->name('hoteles.propios');

		Route::get('/admin/hoteles/crear','HotelesController@create')->name('hoteles.create');
		Route::post('/admin/hoteles/crear','HotelesController@store')->name('hoteles.store');
		Route::post('/admin/hoteles/crear/fotos','HotelesController@fotos')->name('hoteles.fotos');
		Route::post('/admin/hoteles/crear/fotos/delete','HotelesController@fotos_delete')->name('hoteles.fotos.delete');
		
		Route::get('/admin/hoteles/editar/{id}','HotelesController@edit')->name('hoteles.edit');
		Route::post('/admin/hoteles/editar/{id}','HotelesController@update')->name('hoteles.update');


		Route::delete('admin/hoteles/eliminar/{id}','HotelesController@delete')->name('hoteles.delete');

		//Habitaciones

		Route::get('/admin/habitaciones/{id}','HabitacionesController@index')->name('habitaciones.index');
		Route::post('admin/habitaciones/{id}/hotel','HabitacionesController@publicar_hotel')->name('habitaciones.hotel');
		Route::get('/admin/habitaciones/{id}/crear','HabitacionesController@create')->name('habitaciones.create');
		Route::post('/admin/habitaciones/{id}/crear','HabitacionesController@store')->name('habitaciones.store');		
		Route::post('/admin/habitaciones/crear/fotos','HabitacionesController@fotos')->name('habitaciones.fotos');
		Route::post('/admin/habitaciones/crear/fotos/delete','HabitacionesController@fotos_delete')->name('habitaciones.fotos.delete');
		Route::get('/admin/habitaciones/editar/{id}','HabitacionesController@edit')->name('habitaciones.edit');
		Route::post('/admin/habitaciones/editar/{id}','HabitacionesController@update')->name('habitaciones.update');
		Route::delete('/admin/habitaciones/eliminar/{id}','HabitacionesController@delete')->name('habitaciones.delete');


		//Equipamientos

			//Baños
				Route::get('/admin/equipamientos/tocador','EquipamientosController@index_tocador')->name('equipos.tocador.index');

				Route::get('/admin/equipamientos/tocador/crear','EquipamientosController@create_tocador')->name('equipos.tocador.create');

				Route::post('/admin/equipamientos/tocador/crear','EquipamientosController@store_tocador')->name('equipos.tocador.store');

				Route::get('/admin/equipamientos/tocador/editar/{id}','EquipamientosController@edit_tocador')->name('equipos.tocador.edit');

				Route::post('/admin/equipamientos/tocador/editar/{id}','EquipamientosController@update_tocador')->name('equipos.tocador.update');

				Route::delete('/admin/equipamientos/tocador/{id}','EquipamientosController@delete_tocador')->name('equipos.tocador.delete');


			///Habitación
				Route::get('/admin/equipamientos/habitacion','EquipamientosController@index_habitacion')->name('equipos.habitacion.index');

				Route::get('/admin/equipamientos/habitacion/crear','EquipamientosController@create_habitacion')->name('equipos.habitacion.create');

				Route::post('/admin/equipamientos/habitacion/crear','EquipamientosController@store_habitacion')->name('equipos.habitacion.store');

				Route::get('/admin/equipamientos/habitacion/edit/{id}','EquipamientosController@edit_habitacion')->name('equipos.habitacion.edit');

				Route::post('/admin/equipamientos/habitacion/edit/{id}','EquipamientosController@update_habitacion')->name('equipos.habitacion.update');

				Route::delete('/admin/equipamientos/habitacion/{id}','EquipamientosController@delete_habitacion')->name('equipos.habitacion.delete');

		//Categorías

			Route::get('/admin/categorias','CategoriasController@index')->name('categorias.index');
			Route::get('/admin/categorias/crear','CategoriasController@create')->name('categorias.create');
			Route::post('/admin/categorias/crear','CategoriasController@store')->name('categorias.store');
			Route::get('/admin/categorias/editar/{id}','CategoriasController@edit')->name('categorias.edit');
			Route::post('/admin/categorias/edit/{id}','CategoriasController@update')->name('categorias.update');
			Route::delete('/admin/categorias/{id}','CategoriasController@delete')->name('categorias.delete');
		//Servicios

			Route::get('admin/servicios','ServiciosController@index')->name('servicios.index');
			Route::get('admin/servicios/crear','ServiciosController@create')->name('servicios.create');
			Route::post('admin/servicios/crear','ServiciosController@store')->name('servicios.store');
			Route::get('admin/servicios/editar/{id}','ServiciosController@edit')->name('servicios.edit');
			Route::post('admin/servicios/editar/{id}','ServiciosController@update')->name('servicios.update');
			Route::delete('admin/servicios/{id}','ServiciosController@delete')->name('servicios.delete');

		//Subservicios

			Route::get('admin/servicios/subservicios/{id_servicios}','SubserviciosController@index')->name('subservicios.index');

			Route::get('admin/servicios/subservicios/{id_servicios}/crear','SubserviciosController@create')->name('subservicios.create');

			Route::post('admin/servicios/subservicios/{id_servicios}/crear','SubserviciosController@store')->name('subservicios.store');

			Route::get('admin/servicios/subservicios/{id_servicios}/editar/{id}','SubserviciosController@edit')->name('subservicios.edit');

			Route::post('admin/servicios/subservicios/{id_servicios}/editar/{id}','SubserviciosController@update')->name('subservicios.update');

		//Disponibilidad

			Route::get('admin/check-in','DisponibilidadController@index')->name('disponibilidad.index');
			
			Route::post('admin/check-in','DisponibilidadController@disponibilidad')->name('disponibilidad.disponibilidad');

			Route::post('admin/check-in/store','DisponibilidadController@store')->name('disponibilidad.store');

			Route::post('admin/check-in/eliminar','DisponibilidadController@eliminar')->name('disponibilidad.eliminar');

		//Aprobaciones

			Route::get('admin/aprobaciones/inguat','AprobacionesController@inguat')->name('aprobaciones.inguat');

			Route::post('admin/aprobaciones/inguat/aprobar','AprobacionesController@inguat_aprobar')->name('aprobaciones.inguat.aprobar');

			Route::post('admin/aprobaciones/inguat/rechazar','AprobacionesController@inguat_rechazar')->name('aprobaciones.inguat.rechazar');


			Route::get('admin/aprobaciones/guatehoteles','AprobacionesController@guatehoteles')->name('aprobaciones.guatehoteles');

			Route::post('admin/aprobaciones/guatehoteles/aprobar','AprobacionesController@guatehoteles_aprobar')->name('aprobaciones.guatehoteles.aprobar');

			Route::post('admin/aprobaciones/guatehoteles/rechazar','AprobacionesController@guatehoteles_rechazar')->name('aprobaciones.guatehoteles.rechazar');

		//Usuarios

			Route::get('/admin/usuarios','UsuariosController@index')->name('usuarios.index');

		//Cuenta
			Route::get('admin/cuenta/clave','CuentaController@clave')->name('cuenta.clave');
			Route::post('admin/cuenta/clave','CuentaController@clave_update')->name('cuenta.clave.update');

			Route::get('admin/cuenta/informacion','CuentaController@cuenta')->name('cuenta.cuenta');
			Route::post('admin/cuenta/informacion','CuentaController@cuenta_update')->name('cuenta.update');
		//Configuraciones

			//Preguntas
			
			Route::get('/admin/preguntas/','PreguntasController@index')->name('preguntas.index');
			Route::get('/admin/preguntas/crear','PreguntasController@create')->name('preguntas.create');
			Route::post('/admin/preguntas/crear','PreguntasController@store')->name('preguntas.store');
			Route::get('/admin/preguntas/editar/{id}','PreguntasController@edit')->name('preguntas.edit');
			Route::put('/admin/preguntas/editar/{id}','PreguntasController@update')->name('preguntas.update');
			Route::delete('/admin/preguntas/{id}','PreguntasController@delete')->name('preguntas.delete');

			//Páginas

			Route::get('/admin/pagina/{id}','PaginasController@index')->name('paginas.index');
			Route::put('/admin/pagina/{id}','PaginasController@update')->name('paginas.update');

			//Contacto

			Route::get('/admin/contacto','ContactoController@index')->name('contacto.index');
			Route::post('/admin/contacto','ContactoController@update')->name('contacto.update');

			//General
			Route::get('/admin/general','ConfiguracionesController@general')->name('config.general');
			Route::post('/admin/general','ConfiguracionesController@general_store')->name('config.general.store');

			//Banner
			Route::get('/admin/banner','ConfiguracionesController@banner')->name('config.banner');
			Route::post('/admin/banner','ConfiguracionesController@banner_store')->name('config.banner.store');

			//Departamentos

			Route::get('/admin/departamentos','DepartamentosController@index')->name('departamentos.index');
			Route::get('/admin/departamentos/{id}','DepartamentosController@edit')->name('departamentos.edit');
			Route::post('/admin/departamentos/{id}','DepartamentosController@update')->name('departamentos.update');	
	});

	Route::get('/notify/bienvenido/{id}','MensajesController@bienvenido')->name('notify.bienvenido');