@extends('layouts.app')

@section('content')
        <style type="text/css">
          .img-card{
            min-width: 100%;
            max-width: 100%;
            min-height: 100%;
            max-height: 100%;
            position: absolute;
          }

          @media(max-width:768px){
              .img-card {
                min-width: 100%;
                max-width: 100%;
                min-height: 150px;
                max-height: 150px;
                position: relative;
              }
          }

        </style>
        <section class="pt-md-4 pb-md-0 bg-dark">
          <div class="container">
            <div class="row justify-content-between align-items-center">
              <div class="col-lg-8 col-md-9">
                <div class="d-none d-md-block">
                  <br>
                </div>
                <h1 class="d-none d-md-block" style="color: white;">Busca más fácil tu hotel</h1>
                <p class="lead"></p>
              </div>
              <div class="col-md-3 d-none d-md-none">
                <img src="{{asset('img/hotel.png')}}" style="width: 1000px;" alt="Image">
              </div>
            </div>
            <form action="{{asset('/hoteles')}}" method="GET">
                <div class="row">
                    <div class="col-12 col-md-2">
                       <label style="margin: 0px; color: white;">Departamento</label>
                       <select class="form-control" name="departamento" id="departamento">
                           <option value="">Selecciona una opción</option>
                           @foreach($departamentos as $key)
                            <option value="{{$key->id}}"
                              <?php if (request()->departamento == $key->id) {
                                echo 'selected="selected"';
                              } ?>
                              >{{$key->departamento}}</option>
                           @endforeach
                       </select><br>
                    </div>
                    <div class="col-12 col-md-2">
                       <label style="margin: 0px; color: white;">Municipio</label>
                       <select class="form-control" name="municipio" id="municipio">
                           <option value="">Selecciona una opción</option>
                            @foreach($municipios as $key)
                            <option value="{{$key->id}}"
                              <?php if (request()->municipio == $key->id) {
                                echo 'selected="selected"';
                              } ?>
                              >{{$key->municipio}}</option>
                           @endforeach
                       </select><br>
                    </div>
                    <div class="col-12 col-md-3">
                        <label style="margin: 0px; color: white;">Fecha de llegada</label>
                        <input type="date" name="check_in" class="form-control"   required="required" value="{{request()->check_in}}"><br>
                    </div>
                    <div class="col-12 col-md-3">
                        <label style="margin: 0px; color: white;">Fecha de salida</label>
                        <input type="date" name="check_out" class="form-control"  required="required" value="{{request()->check_out}}"><br>
                    </div>
                    <div class="col-12 col-md-1">
                        <label style="margin: 0px; color: white;">Huésped</label>
                        <input type="number" name="huesped" class="form-control" id="huesped" value="{{request()->huesped}}" required="required" min="1"><br>
                    </div>
                    <div class="col-12 col-md-1">
                        <br>
                        <input type="hidden" name="a" id="form-a" value="{{$data['a']}}">
                        <input type="hidden" name="n" id="form-n" value="{{$data['n']}}">
                        <center><button class="btn btn-primary" type="submit">Buscar</button></center>
                    </div>
                </div>
                <div style="display: none;" id="form-edad">
                  <?php
                    if (is_array(request()->edad)) {
                      foreach (request()->edad as $key) {
                        echo '<input type="hidden" name="edad[]" value="'.$key.'">';
                      }
                    }
                  ?>
                </div>
            </form>
          </div>
        </section>
        <?php $data_hoteles = $data; ?>

        <section>
          <div class="pl-4 pr-5 pt-1 pb-1">
            <div class="row">
            	<div class="col-md-3">
                <div class="card" style="border-radius: 10px; box-shadow: 0 0 3px grey;">
                  <div class="card-body">
                    <center>
                      <h5>Filtros</h5>
                    </center>
                      <form action="{{asset('/hoteles')}}" method="GET">

                        <input type="hidden" name="departamento" value="{{request()->departamento}}">
                        <input type="hidden" name="municipio" value="{{request()->municipio}}">

                        <input type="hidden" name="check_in" value="{{request()->check_in}}">
                        <input type="hidden" name="check_out" value="{{request()->check_out}}">

                        <input type="hidden" name="huesped" value="{{request()->huesped}}">

                        <input type="hidden" name="a" id="form-a" value="{{request()->a}}">
                        <input type="hidden" name="n" id="form-n" value="{{request()->n}}">
                          <?php
                            if (is_array(request()->edad)) {
                              foreach (request()->edad as $key) {
                                echo '<input type="hidden" name="edad[]" value="'.$key.'">';
                              }
                            }
                          ?>

                        <h6>Categorías</h6>

                        <?php
                          $array_categoria = array();

                          if (isset($request->categorias)) {
                              if (is_array($request->categorias)) {
                                  $array_categoria = $request->categorias;
                              }
                          }

                        ?>

                        @foreach($categorias as $key)
                          <div class="custom-control custom-checkbox">
                            <input type="checkbox" id="categorias-{{$key->id}}" class="custom-control-input" name="categorias[]" value="{{$key->id}}" <?php if(in_array($key->id,$array_categoria)){
                              echo "checked";
                            } ?>>
                            <label class="custom-control-label" for="categorias-{{$key->id}}">{{$key->categoria}}</label>
                          </div>
                        @endforeach

                        <?php
                          $array_estrellas = array();

                          if (isset($request->estrellas)) {
                              if (is_array($request->estrellas)) {
                                  $array_estrellas = $request->estrellas;
                              }
                          }

                        ?>

                        <h6 class="mt-3">Estrellas</h6>

                        @for($i=0;$i<=5;$i++)
                          <div class="custom-control custom-checkbox">
                            <input type="checkbox" id="estrellas-{{$i}}" class="custom-control-input"
                            name="estrellas[]" value="{{$i}}" <?php if(in_array($i,$array_estrellas)){
                              echo "checked";
                            } ?>>
                            <label class="custom-control-label" for="estrellas-{{$i}}">{{$i}}
                                @if($i==1) estrella @else estrellas @endif</label>
                          </div>
                        @endfor

                        <h6 class="mt-3">Recomendados por:</h6>

                        <?php
                          $array_recomendaciones = array();

                          if (isset($request->recomendaciones)) {
                              if (is_array($request->recomendaciones)) {
                                  $array_recomendaciones = $request->recomendaciones;
                              }
                          }

                        ?>

                        @foreach($empresas as $key)
                          <div class="custom-control custom-checkbox">
                            <input type="checkbox" id="empresas-{{$key->id}}" class="custom-control-input" name="recomendaciones[]" value="{{$key->id}}" <?php if(in_array($key->id,$array_recomendaciones)){
                              echo "checked";
                            } ?>>
                            <label class="custom-control-label" for="empresas-{{$key->id}}">{{$key->empresa}}</label>
                          </div>
                        @endforeach

                        <center>
                          <br>
                          <button class="btn btn-primary" type="submit">Aplicar filtro</button>
                        </center>
                      </form>
                  </div>
                </div>
              </div>
                @if($hoteles->count() != 0)
                	<div class="col-md-9">
                		<div class="row">
                      @foreach($hoteles as $key)
                        <div class="col-md-12 mb-3 p-0" style="min-width: 100% !important">
                           <div class="card" style="border-radius: 10px; box-shadow: 0 0 3px grey;">
                              <div class="row">
                                <div class="col-md-4">
                                  <?php $i_ser = 0; ?>
                                    @if(isset($data_hoteles))
                                        <?php $url = route('hotel.single',$key->url).$data_hoteles['url']; ?>
                                      @else
                                        <?php $url = route('hotel.single',$key->url)?>
                                      @endif
                                    @if($key->imagenes->count() == 0)
                                      <a href="{{$url}}">
                                        <img class="card-img-top img-card" src="{{asset('img/hotel.png')}}" alt="Hotel" />
                                      </a>
                                    @else
                                      <a href="{{$url}}">
                                        <img class="card-img-top img-card" src="{{asset($key->imagenes[0]->img)}}" alt="Hotel" />
                                      </a>
                                    @endif
                                </div>
                                <div class="col-md-8">
                                  <div class="card-body" style="min-height: 200px;">
                                     <a href="{{$url}}" class="m-0"><h6 class="m-0">{{$key->nombre}}</h6></a>
                                      @if($key->servicios_principales_count() != 0)
                                        <small class="mt-1">Servicios </small>
                                        <div data-flickity='{ "cellAlign": "center", "contain": true, "pageDots":true, "wrapAround":true, "autoPlay":false, "imagesLoaded":true, "groupCells": true,"groupCells": 3,"freeScroll": true}'>
                                          <?php $i_ser = 1; $i=0; ?>
                                                <?php
                                                $ser_cant = $key->servicios_principales_count();
                                                if ($ser_cant >= 5) {
                                                  $cant=2;
                                                }else{
                                                  $cant =  12 / $ser_cant;
                                                }
                                                $data = $key->servicios_principales();
                                            ?>

                                            @for($i=0; $i<($ser_cant*2); $i++)
                                              <div class="col-{{$cant}}" style="padding: 0px;">
                                                  <img style="display: inline-block;" class="material-icons"
                                                  src="{{asset($data[$i])}}" data-toggle="tooltip" data-placement="top"
                                                  <?php $i++; ?>
                                                  title="{{$data[$i]}}">
                                                </div>
                                            @endfor
                                        </div>
                                      @endif
                                      <div class="mb-1 mt-3">
                                      <div>

                                        <div class="row">
                                          <div class="col-md-4">
                                              <h5>
                                                <small>
                                                  Desde
                                                  <strong>
                                                    @if(session('id_moneda')==2) Q @endif
                                                    @if(session('id_moneda')==1) $ @endif
                                                 </strong>
                                                </small>
                                                <strong> {{$key->precio_desde(session('id_moneda')) }} </strong>
                                              </h5>
                                          </div>

                                          <div class="col-md-4">
                                            @for($e=0;$e<$key->estrellas;$e++)
                                              <i class="material-icons text-warning" style="display: inline-block;">star</i>
                                            @endfor
                                          </div>

                                          <div class="col-md-4">
                                            <div class="bg-dark text-white" style="min-width: 50px; max-width: 50px; float: right; border-radius: 5px;">
                                              <center>{{$key->promedio()}}</center>
                                            </div>
                                          </div>

                                        </div>
                                        <div class="row">
                                          <div class="col-md-5">
                                              <center>
                                                @if ($key->recomendaciones->count() != 0)
                                                <strong>recomendado por:</strong><br>
                                                  <div class="row">
                                                    @foreach($key->recomendaciones as $key2)
                                                    <div class="col">
                                                      <img src="{{asset($key2->empresa->logo)}}" width="100px" height="40px">
                                                    </div>
                                                    @endforeach
                                                  </div>
                                                @endif
                                              </center>
                                          </div>
                                          <div class="col-md-7">
                                            <div class="mt-2"></div>
                                            @if(isset($data_hoteles))
                                              @if($key->check_disponibilidades($data_hoteles) == 'OK')
                                                <small class="text-success">Hay habitaciones disponibles para la fecha indicada </small>
                                              @else
                                                <small class="text-danger">{{$key->check_disponibilidades($data_hoteles)}}</small>
                                              @endif
                                            @endif
                                          </div>
                                        </div>
                                    </div>
                                  </div>
                                </div>
                              </div>
                          </div>
                        </div>
                      @endforeach
                      <div class="col-md-12">
                        <nav class="d-flex justify-content-between pt-2" aria-label="Page navigation">
                          <ul class="pagination">

                          </ul>
                            {!! $hoteles->render() !!}
                          <ul class="pagination">

                          </ul>
                        </nav>
                      </div>
                    </div>
        			    </div>
                 @else
                  <div class="col-md-9">
                    <div class="mt-5"></div>
                    <center>
                      <svg xmlns="http://www.w3.org/2000/svg" width="200" height="200" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-search"><circle cx="11" cy="11" r="8"></circle><line x1="21" y1="21" x2="16.65" y2="16.65"></line></svg>
                      <h3>No se encontraron resultado <br> que coincida con la búsqueda</h3>
                    </center>
                  </div>
                @endif
              </div>
            </div>
          </div>
        </section>



@endsection

@section('script')
    <script type="text/javascript">
    var departamentos = [
      <?php
        foreach ($departamentos as $key) {
          echo "
            {
              id:".$key->id.',
              municipios:[
            ';

            foreach ($key->municipios as $key2) {
              echo "
                {
                  id:".$key2->id.",
                  municipio: '".$key2->municipio."'
                },
              ";
            }

            echo "]},";
        }
      ?>
    ];

    $('#departamento').change(function(){

      var departamento_id = $(this).val();

      if (departamento_id == '') {

        var option = '<option value="">Selecciona una opción</option>';
        $('#municipio').html(option);

      }else{
        cargarMunicipios(departamento_id);
      }
    });

    function cargarMunicipios(departamento_id, selection = ''){
        var option = '<option value="">Selecciona una opción</option>';

        var filtrados = departamentos.filter(function(departamento){
            return departamento.id === Number(departamento_id);
        });

        var municipios = filtrados[0].municipios;

        for (let i = 0; i < municipios.length; i++) {
            var seleccionado = selection === municipios[i].id ? 'selected' : '';
            option = option + '<option value="'+municipios[i].id+'" '+ seleccionado +'>'+municipios[i].municipio+'</option>';
        }

        $('#municipio').html(option);
    }

    $(document).ready(function(){
        var departamento = "{{request()->departamento}}";
        var seleccionado = '';
        if(departamento) {
            var municipio = "{{request()->municipio}}";
            if(municipio) {
                seleccionado = Number(municipio);
            }
            cargarMunicipios(departamento, seleccionado);
        }
    });
  </script>
@endsection
