<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Departamentos;
use App\Preguntas;
use App\Paginas;
use App\Hoteles;
use App\Habitaciones;
use App\Configuraciones;
use App\Monedas;
use App\Notifications\Mensaje;
use App\User;
use App\Servicios;
use App\Equipamiento;
use App\Hoteles_valoraciones;
use Auth;
use App\Categorias;
use App\Empresas;

class PortalController extends Controller
{

    public function cambiar_divisa($id){

        $divisa = Monedas::find($id);

        if ($divisa) {

            session(['moneda_simbolo' => $divisa->simbolo]);
            session(['moneda_img' => $divisa->bandera]);
            session(['id_moneda'      => $divisa->id]);
        }

        return redirect()->back()->with('success','Divisa cambiada con éxito');
    }

    public function index(){

        $hoteles_guatehoteles = Hoteles::orderBy('id', 'DESC')
            ->where('publicado','S')
            ->where('borrado','N')
            ->whereHas('recomendaciones',function($q){
                $q->where('id_empresa',1)->where('aprobacion','S');
            })->take(8)->get();

        $hoteles_inguat = Hoteles::orderBy('id', 'DESC')->where('publicado','S')->where('borrado','N')->whereHas('recomendaciones',function($q){
            $q->where('id_empresa',2)->where('aprobacion','S');
        })->take(8)->get();

//        dd($hoteles_guatehoteles->first());

    	$departamentos = Departamentos::all();
    	return view('welcome',compact('departamentos','hoteles_inguat','hoteles_guatehoteles'));
    }

    public function hotel(Request $request){
        $edad_minima = 18;

//        if (is_null($request->departamento) ||
//            is_null($request->municipio) ||
//            is_null($request->check_in) ||
//            is_null($request->check_out) ||
//            is_null($request->huesped) ||
//            is_null($request->a) ||
//            is_null($request->n)) {
//
//
//            if (is_null($request->departamento)) {
//                $request->departamento = 0;
//            }
//
//            if (is_null($request->check_in) || is_null($request->check_out)) {
//                $request->check_in = date('o-m-d');
//                $request->check_out = date('o-m-d');
//            }
//
//            $request->municipio = 0;
//            $request->huesped = 1;
//            $request->a = 1;
//            $request->n = 0;
//
//        }else{
//
//            if ($request->n > 0) {
//                if (is_null($request->edad)) {
//                    return redirect('/');
//                }else{
//
//                    if (is_array($request->edad) == false) {
//                        return redirect('/');
//                    }else{
//
//                        if (count($request->edad) != $request->n) {
//                            return redirect('/');
//                        }else{
//                            $edad_minima = min($request->edad);
//                        }
//                    }
//                }
//            }
//        }
//
//        dd(request()->all());
        $data = [
            'departamento' => $request->departamento,
            'municipio' => $request->municipio,
            'check_in'  => $request->check_in,
            'check_out' => $request->check_out,
            'huesped'   => $request->a + $request->n,
            'a' => $request->a,
            'n' => $request->n,
            'edad' => $request->edad,
            'edad_minima' => $edad_minima,
            'url' => substr($_SERVER["REQUEST_URI"], 8)
        ];
        $hoteles = Hoteles::inRandomOrder(rand(999,99999))
            ->whereNull('edad_minima')->orWhere('edad_minima','<=',$edad_minima)
            ->where('publicado','S')
            ->departamento(request()->departamento)
            ->municipio(request()->municipio)
            ->estrellas(request()->estrellas)
            ->categorias(request()->categorias)
            ->recomendaciones(request()->recomendaciones)
            ->where('borrado','N')
            ->whereHas('habitaciones',function($q) {
                $q->where('huesped','>=', (request()->a + request()->n));
            })->paginate(24);
//            ->paginate(24);
//        dd(request()->all());
        $departamentos = Departamentos::all();

//        if ($request->departamento == 0 && $request->municipio == 0) {
//
            $municipios=[];
//
//        }else{
//
//            $X =  Departamentos::find($data['departamento']);
//
//            if (is_null($X)) {
//               return redirect('/');
//            }else{
//                $municipios = $X->municipios;
//            }
//
//            if ($request->municipio == 0) {
//
//                $hoteles = $hoteles->whereHas('ubicacion',function($q) use ($data){
//                    $q->where('id_departamento',$data['departamento']);
//                });
//
//            }else{
//
//                $hoteles = $hoteles->whereHas('ubicacion',function($q) use ($data){
//                    $q->where('id_municipio',$data['municipio'])->where('id_departamento',$data['departamento']);
//                });
//
//            }
//        }
//
//        if (isset($request->categorias)) {
//            if (is_array($request->categorias)) {
//                $hoteles = $hoteles->whereIn('id_categoria',$request->categorias);
//            }
//        }

//        if (isset($request->estrellas)) {
//
//            if (is_array($request->estrellas)) {
////                dd('entro en el filtro de estrellas', $request->estrellas);
//                $hoteles = $hoteles->whereIn('estrellas',$request->estrellas);
//            }
//        }

//        if (isset($request->recomendaciones)) {
//            if (is_array($request->recomendaciones)) {
//                $hoteles = $hoteles->whereHas('recomendaciones',function($q) use ($request){
//                    $q->whereIn('id_empresa',$request->recomendaciones)->where('aprobacion','S');
//                });
//            }
//        }
//

        $categorias = Categorias::all();
        $empresas = Empresas::all();


        return view('hoteles',compact(
            'hoteles','departamentos','municipios','data','categorias','empresas','request'));
    }

    public function hotel_single($url,Request $request){

        $check_in  = $request->check_in;
        $check_out = $request->check_out;
        $huesped   = $request->huesped;

        if ($check_in!='' && $check_out!='' && $huesped!='') {
            $reserva_url = '?check_in='.$check_in.'&check_out='.$check_out.'&huesped='.$huesped;
        }else{
            $reserva_url = '';
        }

        if (is_null($request->a)==false && is_null($request->n)==false) {
            $huesped = $request->a + $request->n;
        }

        $hotel = Hoteles::where('url',$url)->where('borrado','N')->where('publicado','S')->first();

        if (is_null($hotel) || $hotel->count() == 0 || empty($hotel)) {
             abort(404);
             exit();
        }

        $servicios = Servicios::all();
        $hotel_servicios = array();
        $equipamiento = Equipamiento::all();

        foreach ($hotel->servicios as $key) {
            array_push($hotel_servicios, $key->servicio->id);
        }

        $x5 = Hoteles_valoraciones::all()->where('id_hotel',$hotel->id)->whereIn('calificacion',[5])
        ->count();
        $x4 = Hoteles_valoraciones::all()->where('id_hotel',$hotel->id)->whereIn('calificacion',[4])
        ->count();
        $x3 = Hoteles_valoraciones::all()->where('id_hotel',$hotel->id)->whereIn('calificacion',[3])
        ->count();
        $x2 = Hoteles_valoraciones::all()->where('id_hotel',$hotel->id)->whereIn('calificacion',[2])
        ->count();
        $x1 = Hoteles_valoraciones::all()->where('id_hotel',$hotel->id)->whereIn('calificacion',[1,0])
        ->count();

        $comentarios = $x5 + $x4 + $x3 + $x2+ $x1;

        if ($comentarios!=0) {
           $porcentaje[0]= $x5*100/$comentarios;
           $porcentaje[1]= $x4*100/$comentarios;
           $porcentaje[2]= $x3*100/$comentarios;
           $porcentaje[3]= $x2*100/$comentarios;
           $porcentaje[4]= $x1*100/$comentarios;
       }else{
            $porcentaje[0]= 0;
            $porcentaje[1]= 0;
            $porcentaje[2]= 0;
            $porcentaje[3]= 0;
            $porcentaje[4]= 0;
       }

        if (Auth::user()!='') {
            $user_comentario = Hoteles_valoraciones::all()->where('id_hotel',$hotel->id)->where('user_id',Auth::user()->id)->first();
        }else{
            $user_comentario = '';
        }



        return view('hotel_single',compact('hotel','servicios','hotel_servicios','equipamiento','porcentaje','x5','x4','x3','x2','x1','comentarios','user_comentario','check_in','check_out','huesped','reserva_url'));

    }

    public function comentario(Request $request){

        $valoracion = New Hoteles_valoraciones();
        $valoracion->id_hotel = $request->id_hotel;
        $valoracion->user_id = Auth::user()->id;
        $valoracion->calificacion = $request->valoracion;
        $valoracion->comentario   = $request->comentario;
        $valoracion->save();
        return redirect()->back()->with('success','Muchas gracias por tu opinión');
    }

    public function comentario_update(Request $request){

        $valoracion = Hoteles_valoraciones::all()->where('id_hotel',$request->id_hotel)->where('user_id',Auth::user()->id)->first();

        $valoracion->calificacion = $request->valoracion;
        $valoracion->comentario   = $request->comentario;
        $valoracion->save();

        return redirect()->back()->with('success','Muchas gracias por tu opinión');
    }

    public function habitacion_single($url,$id){

        //$hotel = Hoteles::where('url',$url)->where('borrado','N')->where('publicado','S')->first();

        $habitacion = Habitaciones::where('id',$id)->where('publicado','S')
            ->whereHas('hotel',function($q) use ($url) {
            $q->where('borrado','N')->where('publicado','S')->where('url',$url);
        })->first();

        if (is_null($habitacion) || $habitacion->count() == 0 || empty($habitacion)) {
             abort(404);
             exit();
        }


        $equipamiento = Equipamiento::all();
        $ser_tocador  = Equipamiento::all()->where('tipo','tocador');
        $ser_habitacion = Equipamiento::all()->where('tipo','habitacion');

        $habitacion_equipamiento = array();

        foreach ($habitacion->equipamientos as $key) {
            array_push($habitacion_equipamiento, $key->id_equipo);
        }

        $habitacion_equipamiento = array();

        foreach ($habitacion->equipamientos as $key) {
            array_push($habitacion_equipamiento,$key->id_equipo);
        }


        return view('habitacion_single',compact('habitacion','ser_habitacion','ser_tocador','equipamiento','habitacion_equipamiento'));

        return 'ok';
    }

    public function preguntas(){
    	$preguntas = Preguntas::all();
    	return view('preguntas',compact('preguntas'));
    }

    public function quienes_somos(){
    	$pagina = Paginas::find(1);
    	return view('pagina',compact('pagina'));
    }

    public function terminos(){
    	$pagina = Paginas::find(2);
    	return view('pagina',compact('pagina'));
    }

    public function contacto(){

        $contacto = Configuraciones::where('id','=',1)
            ->orWhere('id','=',2)
            ->get()
        ;
        return view('contacto',compact('contacto'));
    }

    public function contacto_enviar(Request $request){

        $users = User::all()->where('rol_id',1);

        foreach ($users as $data) {

            $data->to_nombre = $request->nombre;
            $data->to_email = $request->email;
            $data->asunto = $request->asunto;
            $data->mensaje = $request->mensaje;
            $data->notify(new Mensaje());

        }

        return 0;
    }
}
