<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Hoteles;
use App\User;
use App\Habitaciones;
use Auth;

class HomeController extends Controller
{
    
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {

        if (Auth::user()->rol_id==3) {
            return redirect('/');
        }

        $hoteles = Hoteles::all()->where('publicado','S')->count();
        $user = User::all()->count();

        $habitaciones = Habitaciones::where('publicado','S')->where('borrado','N')->whereHas('hotel',function($q){
            $q->where('publicado','S')->where('borrado','N');
        })->count();

        $HNR = Hoteles::all()->where('publicado','S')->where('reclamar','S')->count();
        $HR = Hoteles::all()->where('publicado','S')->where('reclamar','N')->count();

        $h0 = Hoteles::all()->where('publicado','S')->where('estrellas',0)->count(); 
        $h1 = Hoteles::all()->where('publicado','S')->where('estrellas',1)->count();
        $h2 = Hoteles::all()->where('publicado','S')->where('estrellas',2)->count();
        $h3 = Hoteles::all()->where('publicado','S')->where('estrellas',3)->count();
        $h4 = Hoteles::all()->where('publicado','S')->where('estrellas',4)->count();
        $h5 = Hoteles::all()->where('publicado','S')->where('estrellas',5)->count();

        $roles = array();

        $roles[0] = User::all()->where('rol_id',2)->where('rol_id', '!=', 1)->count();
        $roles[1] = User::all()->where('rol_id',3)->where('rol_id', '!=', 1)->count();
        $roles[2] = User::all()->where('rol_id',4)->where('rol_id', '!=', 1)->count();
        $roles[3] = User::all()->where('rol_id',5)->where('rol_id', '!=', 1)->count();

        //Porcentaje
        $porcentaje = array();
        foreach ($roles as $key) {
            $data = ($key * 100) / $user;
            array_push($porcentaje, $data);
        }

        return view('home',compact('hoteles','user','habitaciones','HNR','HR','h0','h1','h2','h3','h4','h5','roles','porcentaje'));
    }
}
