<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Categorias;
use App\Hoteles;

class CategoriasController extends Controller
{
    public function index(){
    	$categorias = Categorias::all();
    	$i=1;
    	return view('admin.categorias.index',compact('categorias','i'));
    }

    public function create(){
    	return view('admin.categorias.create');
    }

    public function store(Request $request) {

    	$buscar = Categorias::all()->where('categoria',$request->categoria)->count();

    	if ($buscar>0) {
    		return redirect()->back()->with('error_equipo','El nombre de la categoría ya se encuentra registrada')
    		->with('error_equipo_value',$request->categoria);
    	}

    	$categoria = new Categorias();
    	$categoria->categoria = $request->categoria;
    	$categoria->save();

    	return redirect()->route('categorias.index')->with('success','Registrado')->with('mensaje','Categoría registrada con éxito');
    }

    public function edit($id){
    	$categoria = Categorias::find($id);
    	return view('admin.categorias.edit',compact('categoria'));
    }

    public function update($id, Request $request){
    	$buscar = Categorias::all()->where('categoria',$request->categoria)->where('id','!=',$id)->count();

    	if ($buscar>0) {
    		return redirect()->back()->with('error_equipo','El nombre de la categoría ya se encuentra registrada')
    		->with('error_equipo_value',$request->categoria);
    	}

    	$categoria = Categorias::find($id);
    	$categoria->categoria = $request->categoria;
    	$categoria->save();

    	return redirect()->route('categorias.index')->with('success','Actualizado')->with('mensaje','Categoría Actualizada con éxito');
    }

    public function delete($id){
    	$buscar = Hoteles::all()->where('id_categoria',$id)->count();

    	if ($buscar>0) {
    		return redirect()->route('categorias.index')->with('success','Error')->with('mensaje','No se puede eliminar la categoría porqué un hotel o más la utiliza');    		
    	}else{
    		$categoria = Categorias::find($id);
    		$categoria->delete();

    		return redirect()->route('categorias.index')->with('success','Eliminado')->with('mensaje','Categoría eliminada con éxito');
    	}
    }
}
