@extends('admin.layouts.app')

@section('breadcrumb')
	<li class="breadcrumb-item"><a href="javascript:void(0);">Configuraciones</a></li>
    <li class="breadcrumb-item" aria-current="page"><a href="{{route('preguntas.index')}}">Preguntas Frecuentes</a></li>
    <li class="breadcrumb-item active" aria-current="page"><span>Actualizar</span></li>
@endsection

@section('css')

@endsection

@section('content')
<div class="row layout-spacing layout-top-spacing feather-icon">
    <div id="font-icon_feather" class="col-lg-12">
        <div class="statbox widget box box-shadow">
            <div class="widget-content widget-content-area bx-top-6">
                <div class="icon-section">
                    <div class="row">
                        <div class="col-xl-12">
                        	
                            <center><h4>Actualizar Pregunta</h4></center>
                            <hr>

                            <form action="{{route('preguntas.update',$pregunta->id)}}" method="post">
                                @csrf
                                 <input name="_method" type="hidden" value="PUT">
                                <div class="row">
                                    <div class="col">
                                        <h6>Pregunta <strong class="text-danger">*</strong></h6>
                                        <input type="text" name="pregunta" class="form-control" placeholder="Escriba la pregunta" value="{{$pregunta->pregunta}}"><br>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col">
                                        <h6>Respuesta <strong class="text-danger">*</strong></h6>
                                        <textarea class="form-control" placeholder="Describa la respuesta de la pregunta" name="respuesta" id="respuesta">{{$pregunta->respuesta}}</textarea><br>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col">
                                        <button type="submit" class="btn btn-primary float-right">Actualizar</button>
                                    </div>
                                </div>
                            </form>                                         
                        </div>
                    </div>
                </div>         
            </div>
        </div>
    </div>
</div>
@endsection

@section('script')
    <script type="text/javascript" src="{{asset('js/ckeditor/ckeditor.js')}}"></script>
    <script type="text/javascript">
        CKEDITOR.replace('respuesta');
    </script>
@endsection