<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateHabitacionesPreciosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('habitaciones_precios', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('id_habitacion');
            $table->foreign('id_habitacion')->references('id')->on('habitaciones')->onDelete('cascade');

            $table->unsignedBigInteger('id_moneda');
            $table->foreign('id_moneda')->references('id')->on('monedas')->onDelete('cascade');
            $table->float('precio');
            $table->float('IVA');
            $table->float('ISR');
            $table->float('INGUAT')->nullable();
            $table->float('oferta')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('habitaciones_precios');
    }
}
