<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Hoteles;
use App\Habitaciones;
use App\Notifications\Contacto;
use App\Notifications\Reserva;
use App\Notifications\Bienvenidos;
use App\User;
use Auth;

class MensajesController extends Controller
{

    public function bienvenido($id){
        $user = User::find($id);
        $user->notify(new bienvenidos);
    }

    public function index($id){

    	$hotel = Hoteles::find($id);

    	if (is_null($hotel)) {
    		abort(404);
    	}else{
    		if ($hotel->borrado=='S' || $hotel->publicado=='N') {
    			abort(404);
    		}else{
    			return view('mensaje',compact('hotel'));
    		}
    		
    	}
    }

    public function enviar($id, Request $request){

    	$hotel = Hoteles::find($id);

    	if (is_null($hotel)) {
    		abort(404);
    	}else{
    		if ($hotel->borrado=='S' || $hotel->publicado=='N') {
    			abort(404);
    		}else{
    			$user = User::find($hotel->user_id);
    			$user->hotel = $hotel->nombre;
    			$user->to_nombre = Auth::user()->name;
    			$user->to_email = Auth::user()->email;
    			$user->mensaje = $request->mensaje;
    			$user->notify(new Contacto);
    			return 0;
    		}    		
    	}    	
    }

    public function reserva($id, Request $request){

        if (is_null($request->check_in) || is_null($request->check_out) || is_null($request->huesped)) {
            return redirect()->back();
        }else{
            $check_in = $request->check_in;
            $check_out = $request->check_out;
            $huesped = $request->huesped;
        }

        $habitacion = Habitaciones::find($id);

        if (is_null($habitacion)) {
           abort(404);
        }else{

            if ($habitacion->borrado=='S' || $habitacion->publicar == 'N') {
                abort(404);
            }else{

                if ($huesped <= $habitacion->huesped) {

                    if ($habitacion->disponibilidad($check_in,$check_out) > 0) {
                        # code...
                    }else{
                        return redirect()->back();
                    }

                }else{
                    return redirect()->back();
                }

                $hotel = Hoteles::find($habitacion->id_hotel);

                if (is_null($hotel)) {
                    abort(404);
                }else{
                    if ($hotel->borrado=='S' || $hotel->publicado=='N') {
                        abort(404);
                    }else{
                        return view('reserva',compact('hotel','habitacion','check_in','check_out','huesped'));
                    }            
                }
            }
        }
    }

    public function reserva_enviar(Request $request){

        $check_in = $request->check_in;
        $check_out = $request->check_out;
        $huesped = $request->huesped;

        $habitacion = Habitaciones::find($request->id_habitacion);


        if (is_null($habitacion)) {
           abort(404);
        }else{

            if ($habitacion->borrado=='S' || $habitacion->publicar == 'N') {
                abort(404);
            }else{

                if ($huesped <= $habitacion->huesped) {

                    if ($habitacion->disponibilidad($check_in,$check_out) > 0) {
                        # code...
                    }else{
                        return 1;
                    }

                }else{
                    return 'error';
                }

                $hotel = Hoteles::find($habitacion->id_hotel);

                if (is_null($hotel)) {
                    abort(404);
                }else{
                    if ($hotel->borrado=='S' || $hotel->publicado=='N') {
                        abort(404);
                    }else{
                        
                        $user = User::find($hotel->user_id);
                        $user->hotel = $hotel->nombre;
                        $user->habitacion = $habitacion->nombre;
                        $user->check_in = $check_in;
                        $user->check_out = $check_out;
                        $user->huesped = $huesped;
                        $user->email = $hotel->contactos[0]->email;
                        $user->to_nombre   = Auth::user()->name;
                        $user->to_email    = Auth::user()->email;
                        $user->to_telefono = $request->telefono;
                        $user->mensaje = $request->mensaje;
                        $user->notify(new Reserva);
                        return 'OK';
                    }            
                }
            }
        }
    }
}
