<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Hoteles_recomendaciones;

class AprobacionesController extends Controller
{
    public function inguat(){
    	$titulo = 'Solicitud de aprobaciones para INGUAT';
    	$hoteles = Hoteles_recomendaciones::where('id_empresa',2)->where('aprobacion','N')->wherehas('hotel',function($q){
    		$q->where('borrado','N');
    	})->get();
    	$i=1;
    	$link = 1;
    	return view('admin.aprobaciones.index',compact('titulo','hoteles','i','link'));
    }

    public function inguat_aprobar(Request $request){
    	$hotel = Hoteles_recomendaciones::find($request->id);
    	$hotel->aprobacion='S';
    	$hotel->save();
    	return redirect()->back()->with('success','success')->with('mensaje','Hotel aprobado para INGUAT');
    }	

    public function inguat_rechazar(Request $request){
    	$hotel = Hoteles_recomendaciones::find($request->id);
    	if ($hotel->aprobacion=='N') {
    		$hotel->delete();
    	}

    	return redirect()->back()->with('success','success')->with('mensaje','Hotel rechazado para INGUAT');
    }

    public function guatehoteles(){
    	$titulo = 'Solicitud de aprobaciones para GuateHoteles';
    	$hoteles = Hoteles_recomendaciones::where('id_empresa',1)->where('aprobacion','N')->wherehas('hotel',function($q){
    		$q->where('borrado','N');
    	})->get();
    	$i=1;
    	$link = 2;
    	return view('admin.aprobaciones.index',compact('titulo','i','hoteles','link'));
    }

    public function guatehoteles_aprobar(Request $request){
    	$hotel = Hoteles_recomendaciones::find($request->id);
    	$hotel->aprobacion='S';
    	$hotel->save();
    	return redirect()->back()->with('success','success')->with('mensaje','Hotel aprobado para GuateHoteles');
    }

    public function guatehoteles_rechazar(Request $request){
    	$hotel = Hoteles_recomendaciones::find($request->id);
    	if ($hotel->aprobacion=='N') {
    		$hotel->delete();
    	}

    	return redirect()->back()->with('success','success')->with('mensaje','Hotel rechazado para GuateHoteles');
    }

}
