<!DOCTYPE html>
<html>
  <head>
    <title>Inicia Sesión en GuateHoteles</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" type="text/css" href="{{asset('css/theme.css')}}">
  </head>
  <body>
    <section class="height-100" style="background: linear-gradient(90deg, #0099FF 0%, #6610f2 100%);">
      <img src="{{asset('img/bg.png')}}" alt="Image" class="bg-image opacity-10">
      <div class="container">
        <div class="row justify-content-center">
          <div class="col-lg-5 col-md-7">
            <div class="card py-3 shadow-lg">
              <div class="card-body">
                <h1 class="h2 text-center">
                  <a href="{{route('inicio')}}">
                    <img src="{{asset('img/logo.png')}}" style="height: 70px;">
                  </a>
                </h1>
                {{ __('Reset Password') }}
                <form method="POST" action="{{ route('password.update') }}">
                        @csrf

                        <input type="hidden" name="token" value="{{ $token }}">

                        <div class="form-group row">
                            

                            <div class="col-md-12">
                                <h6 for="email">{{ __('E-Mail Address') }}</h6>
                                <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ $email ?? old('email') }}" required autocomplete="email" autofocus>

                                @error('email')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>

                        <div class="form-group row">
                            

                            <div class="col-md-12">
                                <h6 for="password">{{ __('Password') }}</h6>
                                <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" required autocomplete="new-password">

                                @error('password')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>

                        <div class="form-group row">
                            <div class="col-md-12">
                                <h6 for="password-confirm">{{ __('Confirm Password') }}</h6>
                                <input id="password-confirm" type="password" class="form-control" name="password_confirmation" required autocomplete="new-password">
                            </div>
                        </div>

                        <div class="form-group row mb-0">
                            <div class="col-md-12">
                                <center>                                    
                                    <button type="submit" class="btn btn-primary">
                                    {{ __('Reset Password') }}
                                    </button>
                                </center>
                            </div>
                        </div>
                    </form>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  </body>
</html>