<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Equipamiento;

class EquipamientosController extends Controller
{
    //Baños o tocador

    public function index_tocador(){
    	$equipamiento = Equipamiento::orderBy('id','desc')->where('tipo','tocador')->get();
        $i=1;
        $tipo = 1;
        $titulo = "Equipamiento del baño";
    	return view('admin.equipamientos.index',compact('equipamiento','i','titulo','tipo'));
    }

    public function create_tocador(){
    	$link = Route('equipos.tocador.store');
    	$titulo = 'Equipamiento del tocador';
    	return view('admin.equipamientos.create',compact('titulo','link'));
    }

    public function store_tocador(Request $request){

    	$buscar = Equipamiento::all()->where('equipo',$request->equipo)->where('tipo','tocador')->count();

    	if ($buscar>0) {
    		return redirect()->back()->with('error_equipo','El nombre del equipo ya se encuentra registrado')
    		->with('error_equipo_value',$request->equipo);
    	}else{
    		$equipo = new Equipamiento();
    		$equipo->tipo = 'tocador';
    		$equipo->equipo = $request->equipo;
    		$equipo->save();
    		return redirect()->route('equipos.tocador.index')->with('success','Registrado')->with('mensaje','Equipo registrado con éxito');
    	}
    }

    public function edit_tocador($id){
    	
    	$titulo = 'equipamiento del tocador';
    	$data = Equipamiento::find($id);
    	$link = Route('equipos.tocador.update',$data->id);
    	return view('admin.equipamientos.edit',compact('data','link','titulo'));
    }

    public function update_tocador($id, Request $request){

    	$buscar = Equipamiento::all()->where('equipo',$request->equipo)->where('tipo','tocador')->where('id','!=', $id)->count();

    	if ($buscar>0) {
    		return redirect()->back()->with('error_equipo','El nombre del equipo ya se encuentra registrado')
    		->with('error_equipo_value',$request->equipo);
    	}else{
    		$equipo = Equipamiento::find($id);
    		$equipo->tipo = 'tocador';
    		$equipo->equipo = $request->equipo;
    		$equipo->save();
    		return redirect()->route('equipos.tocador.index')->with('success','Actualizado')->with('mensaje','Equipo actualizado con éxito');
    	}
    }

    public function delete_tocador($id){
    	$delete = Equipamiento::find($id);
    	$delete->delete();

    	return redirect()->route('equipos.tocador.index')->with('success','Eliminado')
    	->with('mensaje','Operación realizada con éxito');
    }

    //Habitación

     public function index_habitacion(){
    	$equipamiento = Equipamiento::orderBy('id','desc')->where('tipo','habitacion')->get();
        $i=1;
        $titulo = "Equipamiento de la habitación";
        $tipo = 2;
    	return view('admin.equipamientos.index',compact('equipamiento','i','titulo','tipo'));
    }

    public function create_habitacion(){
    	$link = Route('equipos.habitacion.store');
    	$titulo = 'Equipamiento de la habitacion';
    	return view('admin.equipamientos.create',compact('titulo','link'));
    }

    public function store_habitacion(Request $request){

    	$buscar = Equipamiento::all()->where('equipo',$request->equipo)->where('tipo','tocador')->count();

    	if ($buscar>0) {
    		return redirect()->back()->with('error_equipo','El nombre del equipo ya se encuentra registrado')
    		->with('error_equipo_value',$request->equipo);
    	}else{
    		$equipo = new Equipamiento();
    		$equipo->tipo = 'habitacion';
    		$equipo->equipo = $request->equipo;
    		$equipo->save();
    		return redirect()->route('equipos.habitacion.index')->with('success','Registrado')->with('mensaje','Equipo registrado con éxito');
    	}
    }


    public function edit_habitacion($id){
    	
    	$titulo = 'equipamiento de la habitación';
    	$data = Equipamiento::find($id);
    	$link = Route('equipos.habitacion.update',$data->id);
    	return view('admin.equipamientos.edit',compact('data','link','titulo'));
    }

    public function update_habitacion($id, Request $request){

    	$buscar = Equipamiento::all()->where('equipo',$request->equipo)->where('tipo','habitacion')->where('id','!=', $id)->count();

    	if ($buscar>0) {
    		return redirect()->back()->with('error_equipo','El nombre del equipo ya se encuentra registrado')
    		->with('error_equipo_value',$request->equipo);
    	}else{
    		$equipo = Equipamiento::find($id);
    		$equipo->tipo = 'habitacion';
    		$equipo->equipo = $request->equipo;
    		$equipo->save();
    		return redirect()->route('equipos.habitacion.index')->with('success','Actualizado')->with('mensaje','Equipo actualizado con éxito');
    	}
    }

    public function delete_habitacion($id){
    	$delete = Equipamiento::find($id);
    	$delete->delete();
    	return redirect()->route('equipos.habitacion.index')->with('success','Eliminado')
    	->with('mensaje','Operación realizada con éxito');
    }

}
