<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Configuraciones;

class ConfiguracionesController extends Controller
{
    public function general(){
    	$titulo = Configuraciones::find(7);
    	$descripcion = Configuraciones::find(8);
        
    	return view('admin.configuraciones.general',compact('titulo','descripcion'));
    }

    public function general_store(Request $request){

    	$titulo = Configuraciones::find(7);
    	$descripcion = Configuraciones::find(8);

    	$titulo->data = $request->titulo;
    	$titulo->save();

    	$descripcion->data = $request->descripcion;
    	$descripcion->save();

    	return redirect()->route('config.general')->with('success','success')->with('mensaje','Ajustes guardados con éxito');
    }

    public function banner(){
        $maxmb = 2;
    	$banner = Configuraciones::find(9);
    	return view('admin.configuraciones.banner',compact('banner','maxmb'));
    }

    public function banner_store(Request $request){

        $file    = $request->file('foto');

        if ($file) {
            $name    = generar_code(8).$file->getClientOriginalName();
            \Storage::disk('banner')->put($name,\File::get($file));
            $url_img = "img/". $name;

            $banner = Configuraciones::find(9);
            $banner->data = $url_img;
            $banner->save();

            return redirect()->route('config.banner')->with('success','success')->with('mensaje','Banner actualizado con éxito');
            
        }else{
            return redirect()->back()->with('success','success')->with('mensaje','Error al actualizar el banner');
        }
    }

}
